/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow;

import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;
import se.diabol.jenkins.workflow.api.Json;
import se.diabol.jenkins.workflow.api.Run;

public class WorkflowApi {
    private static final Logger LOG = Logger.getLogger(WorkflowApi.class.getName());
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private Jenkins jenkins;

    public WorkflowApi(Jenkins instance) {
        this.jenkins = instance;
    }

    public List<Run> getRunsFor(String job) {
        try {
            HttpRequest request = WorkflowApi.requestFor(this.workflowApiUrl(job) + "runs");
            LOG.fine("Getting workflow runs for " + job + " from Workflow API: " + request.getUrl());
            String responseString = this.execute(request);
            LOG.fine("Received workflow runs for " + job + ": " + responseString);
            return WorkflowApi.asListOfRuns(responseString);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Run lastRunFor(String job) {
        return WorkflowApi.returnFirstOrNull(this.getRunsFor(job));
    }

    public Run lastFinishedRunFor(String job) {
        for (Run run : this.getRunsFor(job)) {
            if ("IN_PROGRESS".equals(run.status) || "PAUSED_PENDING_INPUT".equals(run.status)) continue;
            return run;
        }
        return null;
    }

    protected String execute(HttpRequest request) throws IOException {
        HttpResponse response = request.execute();
        return response.parseAsString();
    }

    private static Run returnFirstOrNull(List<Run> runs) {
        if (!runs.isEmpty()) {
            return runs.get(0);
        }
        return null;
    }

    protected static HttpRequest requestFor(String url) throws IOException {
        HttpRequest request = WorkflowApi.requestFactory().buildGetRequest(new GenericUrl(url));
        request.setConnectTimeout(WorkflowApi.timeoutThreshold(2));
        request.setReadTimeout(WorkflowApi.timeoutThreshold(2));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType("application/json; charset=UTF-8");
        headers.setAcceptEncoding("UTF-8");
        headers.setAccept("*/*");
        request.setContent((HttpContent)new EmptyContent());
        headers.setContentLength(Long.valueOf(request.getContent().getLength()));
        request.setHeaders(headers);
        return request;
    }

    protected static int timeoutThreshold(int updateInterval) {
        return (updateInterval <= 0 ? 1 : updateInterval) * 1000 - 250;
    }

    public static HttpRequestFactory requestFactory() {
        return HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
    }

    public static List<Run> asListOfRuns(String response) {
        Run[] runs = Json.deserialize(response, Run[].class);
        return Arrays.asList(runs);
    }

    private String workflowApiUrl(String jobName) {
        return this.jenkinsUrl() + "job/" + jobName + "/wfapi/";
    }

    protected String jenkinsUrl() {
        return this.jenkins().getRootUrl();
    }

    private Jenkins jenkins() {
        if (this.jenkins == null) {
            this.jenkins = JenkinsUtil.getInstance();
        }
        return this.jenkins;
    }
}

