/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.token;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public final class TokenUtils {
    private static final Logger LOG = Logger.getLogger(TokenUtils.class.getName());
    private static final String MESSAGE = "Error during decoding template - ";

    private TokenUtils() {
    }

    public static String decodedTemplate(AbstractBuild<?, ?> build, String template) {
        try {
            return TokenUtils.decode(build, template);
        }
        catch (MacroEvaluationException e) {
            LOG.log(Level.FINE, "Failed to evaluate token using token-macro plugin", e);
            return template;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, MESSAGE + e.getMessage());
            return "";
        }
    }

    private static String decode(AbstractBuild<?, ?> build, String template) throws MacroEvaluationException, IOException, InterruptedException {
        if (build == null) {
            return TokenUtils.hideVariable(template);
        }
        return TokenMacro.expandAll(build, (TaskListener)TaskListener.NULL, (String)template);
    }

    private static String hideVariable(String template) {
        return template.replaceAll("\\$\\{.*?\\}", "...");
    }

    public static boolean stringIsNotEmpty(String string) {
        return string != null && !"".equals(string);
    }
}

