/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.sort;

import hudson.Extension;
import java.io.Serializable;
import se.diabol.jenkins.pipeline.domain.Component;
import se.diabol.jenkins.pipeline.domain.Pipeline;
import se.diabol.jenkins.pipeline.domain.Stage;
import se.diabol.jenkins.pipeline.domain.task.Task;
import se.diabol.jenkins.pipeline.sort.ComponentComparator;
import se.diabol.jenkins.pipeline.sort.ComponentComparatorDescriptor;
import se.diabol.jenkins.pipeline.sort.LatestActivityComparator;

public class FailedJobComparator
extends ComponentComparator
implements Serializable {
    @Override
    public int compare(Component o1, Component o2) {
        if (this.hasFailedJob(this.firstPipeline(o1)) && !this.hasFailedJob(this.firstPipeline(o2))) {
            return -1;
        }
        if (this.hasFailedJob(this.firstPipeline(o2)) && !this.hasFailedJob(this.firstPipeline(o1))) {
            return 1;
        }
        return new LatestActivityComparator().compare(o1, o2);
    }

    private Pipeline firstPipeline(Component component) {
        if (component != null && component.getPipelines() != null && !component.getPipelines().isEmpty()) {
            return component.getPipelines().get(0);
        }
        return null;
    }

    private boolean hasFailedJob(Pipeline pipeline) {
        if (pipeline != null) {
            for (Stage stage : pipeline.getStages()) {
                for (Task task : stage.getTasks()) {
                    if (!task.getStatus().isFailed()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Extension
    public static class DescriptorImpl
    extends ComponentComparatorDescriptor {
        public String getDisplayName() {
            return "Sorting by failed pipelines, then by last activity";
        }

        @Override
        public ComponentComparator createInstance() {
            return new FailedJobComparator();
        }
    }
}

