/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.portlet;

import hudson.Extension;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.kohsuke.stapler.DataBoundConstructor;
import se.diabol.jenkins.pipeline.DeliveryPipelineView;
import se.diabol.jenkins.pipeline.portlet.ReadOnlyDeliveryPipelineView;

public class DeliveryPipelineViewPortlet
extends DashboardPortlet {
    private static final int BOUND = 32000;
    private static final Random GENERATOR = new Random();
    private ReadOnlyDeliveryPipelineView deliveryPipelineView;
    private final String initialJob;
    private final String finalJob;
    private String portletId = null;

    @DataBoundConstructor
    public DeliveryPipelineViewPortlet(String name, String initialJob, String finalJob) throws IOException {
        super(name);
        this.initialJob = initialJob;
        this.finalJob = finalJob;
        this.portletId = this.portletId != null && !"".equals(this.portletId.trim()) ? this.portletId : Integer.toString(GENERATOR.nextInt(32000));
    }

    public String getPortletId() {
        return this.portletId;
    }

    public ReadOnlyDeliveryPipelineView getDeliveryPipelineView() {
        return this.setPipelineView();
    }

    ReadOnlyDeliveryPipelineView setPipelineView() {
        this.deliveryPipelineView = new ReadOnlyDeliveryPipelineView(this.portletId, this.getDashboard().getOwner());
        this.updateView(this.deliveryPipelineView);
        return this.deliveryPipelineView;
    }

    public Api getApi() {
        return this.deliveryPipelineView.getApi();
    }

    public String getInitialJob() {
        return this.initialJob;
    }

    public String getFinalJob() {
        return this.finalJob;
    }

    void updateView(ReadOnlyDeliveryPipelineView view) {
        view.setViewUrl(this.getDashboard().getViewUrl() + "/" + this.getUrl());
        view.setIsPortletView(true);
        view.setShowChanges(false);
        view.setShowAggregatedPipeline(true);
        view.setShowTestResults(true);
        view.setShowAggregatedChanges(true);
        view.setShowPromotions(true);
        view.setShowStaticAnalysisResults(true);
        view.setNoOfPipelines(0);
        ArrayList<DeliveryPipelineView.ComponentSpec> componentSpecs = new ArrayList<DeliveryPipelineView.ComponentSpec>();
        if (this.initialJob != null && !"".equals(this.initialJob.trim())) {
            DeliveryPipelineView.ComponentSpec componentSpec = new DeliveryPipelineView.ComponentSpec("Aggregated view", this.initialJob, this.finalJob, false);
            componentSpecs.add(componentSpec);
        }
        view.setComponentSpecs(componentSpecs);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "Delivery Pipeline Portlet";
        }
    }
}

