/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.task;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.trigger.ManualTriggerResolver;
import se.diabol.jenkins.pipeline.util.BuildUtil;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class ManualStep {
    private final String upstreamProject;
    private final String upstreamId;
    private final boolean enabled;
    private final boolean permission;
    private final Map<String, String> possibleVersions;

    public ManualStep(String upstreamProject, String upstreamId, boolean enabled, boolean permission, Map<String, String> possibleVersions) {
        this.upstreamProject = upstreamProject;
        this.upstreamId = upstreamId;
        this.enabled = enabled;
        this.permission = permission;
        this.possibleVersions = possibleVersions;
    }

    @CheckForNull
    public static ManualStep resolveManualStep(AbstractProject project) {
        if (ManualStep.isManualTrigger(project)) {
            return new ManualStep(project.getName(), null, false, project.hasPermission(Item.BUILD), null);
        }
        return null;
    }

    static boolean isManualTrigger(AbstractProject<?, ?> project) {
        List<ManualTriggerResolver> resolvers = ManualTriggerResolver.all();
        for (ManualTriggerResolver manualTriggerResolver : resolvers) {
            if (!manualTriggerResolver.isManualTrigger(project)) continue;
            return true;
        }
        return false;
    }

    private static List<AbstractProject> getUpstreamManualTriggered(AbstractProject<?, ?> project) {
        List<ManualTriggerResolver> resolvers = ManualTriggerResolver.all();
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        for (ManualTriggerResolver manualTriggerResolver : resolvers) {
            result.addAll(manualTriggerResolver.getUpstreamManualTriggered(project));
        }
        return result;
    }

    @CheckForNull
    public static ManualStep getManualStepLatest(AbstractProject project, AbstractBuild build, AbstractBuild firstBuild) {
        if (ManualStep.isManualTrigger(project)) {
            List<AbstractProject> upstreams = ManualStep.getUpstreamManualTriggered(project);
            for (int i = 0; i < upstreams.size(); ++i) {
                Result result;
                AbstractProject upstream = upstreams.get(i);
                AbstractBuild upstreamBuild = BuildUtil.match((RunList<? extends AbstractBuild>)upstream.getBuilds(), firstBuild);
                if (build == null) {
                    if (upstreamBuild != null && !upstreamBuild.isBuilding() && !ProjectUtil.isQueued(project, firstBuild)) {
                        result = upstreamBuild.getResult();
                        return new ManualStep(upstream.getRelativeNameFrom((ItemGroup)JenkinsUtil.getInstance()), String.valueOf(upstreamBuild.getNumber()), result != null && !result.isWorseThan(Result.UNSTABLE), project.hasPermission(Item.BUILD), null);
                    }
                } else {
                    result = build.getResult();
                    if (upstreamBuild != null && !build.isBuilding() && !ProjectUtil.isQueued(project, firstBuild) && result != null && result.isWorseThan(Result.UNSTABLE)) {
                        return new ManualStep(upstream.getRelativeNameFrom((ItemGroup)JenkinsUtil.getInstance()), String.valueOf(upstreamBuild.getNumber()), true, project.hasPermission(Item.BUILD), null);
                    }
                }
                if (i != upstreams.size() - 1) continue;
                return new ManualStep(upstream.getRelativeNameFrom((ItemGroup)JenkinsUtil.getInstance()), null, false, project.hasPermission(Item.BUILD), null);
            }
        }
        return null;
    }

    @CheckForNull
    public static ManualStep getManualStepAggregated(AbstractProject project, AbstractProject firstProject) {
        if (ManualStep.isManualTrigger(project)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            AbstractProject upstream = (AbstractProject)project.getUpstreamProjects().get(0);
            for (AbstractBuild build : upstream.getBuilds()) {
                AbstractBuild versionBuild = BuildUtil.getFirstUpstreamBuild(build, firstProject);
                if (versionBuild == null || versions.containsKey(versionBuild.getDisplayName())) continue;
                versions.put(versionBuild.getDisplayName(), String.valueOf(versionBuild.getNumber()));
            }
            if (versions.isEmpty()) {
                return new ManualStep(upstream.getName(), null, false, project.hasPermission(Item.BUILD), versions);
            }
            return new ManualStep(upstream.getName(), null, true, project.hasPermission(Item.BUILD), versions);
        }
        return null;
    }

    @Exported
    public String getUpstreamProject() {
        return this.upstreamProject;
    }

    @Exported
    public String getUpstreamId() {
        return this.upstreamId;
    }

    @Exported
    public boolean isEnabled() {
        return this.enabled;
    }

    @Exported
    public boolean isPermission() {
        return this.permission;
    }

    @Exported
    public Map<String, String> getPossibleVersions() {
        return this.possibleVersions;
    }
}

