/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.status;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.status.Status;
import se.diabol.jenkins.pipeline.domain.status.StatusFactory;
import se.diabol.jenkins.pipeline.domain.status.StatusType;
import se.diabol.jenkins.pipeline.domain.status.promotion.AbstractPromotionStatusProvider;
import se.diabol.jenkins.pipeline.domain.status.promotion.PromotionStatus;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class SimpleStatus
implements Status {
    private final StatusType type;
    private final long lastActivity;
    private final long duration;
    private final boolean promoted;
    private final List<PromotionStatus> promotions;
    private static PromotionStatusProviderWrapper promotionStatusProviderWrapper = new PromotionStatusProviderWrapper();

    public SimpleStatus(StatusType type, long lastActivity, long duration) {
        this(type, lastActivity, duration, false, Collections.emptyList());
    }

    public SimpleStatus(StatusType type, long lastActivity, long duration, boolean promoted, List<PromotionStatus> promotions) {
        this.type = type;
        this.lastActivity = lastActivity;
        this.duration = duration;
        this.promoted = promoted;
        this.promotions = promotions;
    }

    @Override
    @Exported
    public List<PromotionStatus> getPromotions() {
        return this.promotions;
    }

    @Override
    @Exported
    public boolean isPromoted() {
        return this.promoted;
    }

    @Override
    @Exported
    public StatusType getType() {
        return this.type;
    }

    @Override
    public long getLastActivity() {
        return this.lastActivity;
    }

    @Override
    @Exported
    public String getTimestamp() {
        if (this.lastActivity != -1L) {
            return PipelineUtils.formatTimestamp(this.lastActivity);
        }
        return null;
    }

    @Override
    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isIdle() {
        return StatusType.IDLE.equals((Object)this.type);
    }

    @Override
    public boolean isQueued() {
        return StatusType.QUEUED.equals((Object)this.type);
    }

    @Override
    public boolean isRunning() {
        return StatusType.RUNNING.equals((Object)this.type);
    }

    @Override
    @Exported
    public boolean isSuccess() {
        return StatusType.SUCCESS.equals((Object)this.type);
    }

    @Override
    @Exported
    public boolean isFailed() {
        return StatusType.FAILED.equals((Object)this.type);
    }

    @Override
    @Exported
    public boolean isUnstable() {
        return StatusType.UNSTABLE.equals((Object)this.type);
    }

    @Override
    @Exported
    public boolean isCancelled() {
        return StatusType.CANCELLED.equals((Object)this.type);
    }

    @Override
    public boolean isNotBuilt() {
        return StatusType.NOT_BUILT.equals((Object)this.type);
    }

    @Override
    public boolean isDisabled() {
        return StatusType.DISABLED.equals((Object)this.type);
    }

    public static Status resolveStatus(AbstractProject project, AbstractBuild build, AbstractBuild firstBuild) {
        if (build == null) {
            if (ProjectUtil.isQueued(project, firstBuild)) {
                return StatusFactory.queued(project.getQueueItem().getInQueueSince());
            }
            if (project.isDisabled()) {
                return StatusFactory.disabled();
            }
            return StatusFactory.idle();
        }
        if (build.isBuilding()) {
            int progress = SimpleStatus.calculateBuildProgress(build);
            return SimpleStatus.statusWithProgress(build, progress);
        }
        return SimpleStatus.getStatusFromResult(build);
    }

    private static Status statusWithProgress(AbstractBuild build, int progress) {
        return StatusFactory.running(progress, build.getTimeInMillis(), System.currentTimeMillis() - build.getTimestamp().getTimeInMillis());
    }

    private static int calculateBuildProgress(AbstractBuild build) {
        return SimpleStatus.calculateBuildProgress(System.currentTimeMillis(), build.getTimestamp().getTimeInMillis(), build.getEstimatedDuration());
    }

    static int calculateBuildProgress(long currentTimeMillis, long timeBuildStarted, long estimatedBuildDuration) {
        int progress = (int)Math.round(100.0 * (double)(currentTimeMillis - timeBuildStarted) / (double)estimatedBuildDuration);
        if (progress > 100 || estimatedBuildDuration < 0L) {
            progress = 99;
        } else if (progress < 0) {
            return 0;
        }
        return progress;
    }

    private static Status getStatusFromResult(AbstractBuild build) {
        Result result = build.getResult();
        if (Result.ABORTED.equals(result)) {
            return StatusFactory.cancelled(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.SUCCESS.equals(result)) {
            return StatusFactory.success(build.getTimeInMillis(), build.getDuration(), SimpleStatus.isBuildPromoted(build), SimpleStatus.getPromotionStatusList(build));
        }
        if (Result.FAILURE.equals(result)) {
            return StatusFactory.failed(build.getTimeInMillis(), build.getDuration(), SimpleStatus.isBuildPromoted(build), SimpleStatus.getPromotionStatusList(build));
        }
        if (Result.UNSTABLE.equals(result)) {
            return StatusFactory.unstable(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.NOT_BUILT.equals(result)) {
            return StatusFactory.notBuilt(build.getTimeInMillis(), build.getDuration());
        }
        throw new IllegalStateException("Result " + result + " not recognized.");
    }

    private static boolean isBuildPromoted(AbstractBuild build) {
        AbstractPromotionStatusProvider promotionStatusProvider;
        List<AbstractPromotionStatusProvider> promotionStatusProviders = promotionStatusProviderWrapper.getAllPromotionStatusProviders();
        if (CollectionUtils.isNotEmpty(promotionStatusProviders) && (promotionStatusProvider = promotionStatusProviders.get(0)) != null) {
            return promotionStatusProvider.isBuildPromoted(build);
        }
        return false;
    }

    private static List<PromotionStatus> getPromotionStatusList(AbstractBuild build) {
        AbstractPromotionStatusProvider promotionStatusProvider;
        ArrayList<PromotionStatus> promotionStatusList = new ArrayList<PromotionStatus>();
        List<AbstractPromotionStatusProvider> promotionStatusProviders = promotionStatusProviderWrapper.getAllPromotionStatusProviders();
        if (CollectionUtils.isNotEmpty(promotionStatusProviders) && (promotionStatusProvider = promotionStatusProviders.get(0)) != null) {
            promotionStatusList.addAll(promotionStatusProvider.getPromotionStatusList(build));
        }
        return promotionStatusList;
    }

    public String toString() {
        return String.valueOf((Object)this.type);
    }

    static void setPromotionStatusProviderWrapper(PromotionStatusProviderWrapper promotionStatusProviderWrapper) {
        SimpleStatus.promotionStatusProviderWrapper = promotionStatusProviderWrapper;
    }

    static class PromotionStatusProviderWrapper {
        PromotionStatusProviderWrapper() {
        }

        public List<AbstractPromotionStatusProvider> getAllPromotionStatusProviders() {
            return AbstractPromotionStatusProvider.all();
        }
    }
}

