/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.User;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Change;

public class UserInfo
extends AbstractItem {
    private final String url;

    public UserInfo(String name, String url) {
        super(name);
        this.url = url;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    public static UserInfo getUser(User user) {
        return new UserInfo(user.getDisplayName(), user.getUrl());
    }

    public static Set<UserInfo> getContributors(List<Change> changes) {
        HashSet<UserInfo> contributors = new HashSet<UserInfo>();
        for (Change change : changes) {
            contributors.add(change.getAuthor());
        }
        return contributors;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)obj;
        return userInfo.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

