/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Change;
import se.diabol.jenkins.pipeline.domain.Component;
import se.diabol.jenkins.pipeline.domain.DownstreamPipeline;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.domain.Route;
import se.diabol.jenkins.pipeline.domain.Stage;
import se.diabol.jenkins.pipeline.domain.TriggerCause;
import se.diabol.jenkins.pipeline.domain.UserInfo;
import se.diabol.jenkins.pipeline.domain.task.Task;
import se.diabol.jenkins.pipeline.sort.BuildStartTimeComparator;
import se.diabol.jenkins.pipeline.util.PipelineUtils;

@ExportedBean(defaultVisibility=100)
public class Pipeline
extends AbstractItem {
    private final AbstractProject firstProject;
    private final AbstractProject lastProject;
    private final List<Stage> stages;
    private String version;
    private List<TriggerCause> triggeredBy;
    private Set<UserInfo> contributors;
    private boolean aggregated;
    private String timestamp;
    private List<Change> changes;
    private int commits;
    private long totalBuildTime;
    private Map<String, Task> allTasks = null;

    public Pipeline(String name, AbstractProject firstProject, AbstractProject lastProject, List<Stage> stages) {
        super(name);
        this.firstProject = firstProject;
        this.lastProject = lastProject;
        this.stages = stages;
    }

    public Pipeline(String name, AbstractProject firstProject, AbstractProject lastProject, String version, String timestamp, List<TriggerCause> triggeredBy, Set<UserInfo> contributors, List<Stage> stages, boolean aggregated) {
        super(name);
        this.firstProject = firstProject;
        this.lastProject = lastProject;
        this.version = version;
        this.triggeredBy = triggeredBy;
        this.contributors = contributors;
        this.aggregated = aggregated;
        this.stages = ImmutableList.copyOf(stages);
        this.timestamp = timestamp;
    }

    public AbstractProject getFirstProject() {
        return this.firstProject;
    }

    public AbstractProject getLastProject() {
        return this.lastProject;
    }

    @Exported
    public List<Stage> getStages() {
        return this.stages;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported
    public boolean isAggregated() {
        return this.aggregated;
    }

    @Exported
    public Set<UserInfo> getContributors() {
        return this.contributors;
    }

    @Exported
    public int getId() {
        return this.hashCode();
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    @Exported
    public List<Change> getChanges() {
        return this.changes;
    }

    public void setCommits(int commits) {
        this.commits = commits;
    }

    @Exported
    public long getTotalBuildTime() {
        return this.totalBuildTime;
    }

    @Exported
    public int getCommits() {
        return this.commits;
    }

    public void calculateTotalBuildTime() {
        if (this.stages.size() == 0) {
            this.totalBuildTime = 0L;
        } else {
            ArrayList<Route> allRoutes = new ArrayList<Route>();
            this.calculatePipelineRoutes(this.getStages().get(0).getTasks().get(0), null, allRoutes);
            long maxTime = 0L;
            for (Route route : allRoutes) {
                long buildTime = route.getTotalBuildTime();
                if (buildTime <= maxTime) continue;
                maxTime = buildTime;
            }
            this.totalBuildTime = maxTime;
        }
    }

    private Route createRouteAndCopyTasks(Route route, Task task) {
        Route currentRoute = new Route();
        if (route != null) {
            currentRoute.setTasks(Lists.newArrayList(route.getTasks()));
        }
        currentRoute.addTask(task);
        return currentRoute;
    }

    void calculatePipelineRoutes(Task task, Route route, List<Route> allRoutes) {
        if (task.getDownstreamTasks() != null && task.getDownstreamTasks().size() > 0) {
            for (String downstreamTaskName : task.getDownstreamTasks()) {
                Route currentRoute = this.createRouteAndCopyTasks(route, task);
                this.calculatePipelineRoutes(this.getTaskFromName(downstreamTaskName), currentRoute, allRoutes);
            }
        } else {
            Route currentRoute = this.createRouteAndCopyTasks(route, task);
            allRoutes.add(currentRoute);
        }
    }

    private Task getTaskFromName(String taskName) {
        if (this.allTasks == null) {
            this.allTasks = new HashMap<String, Task>();
            for (Stage stage : this.stages) {
                for (Task task : stage.getTasks()) {
                    this.allTasks.put(task.getId(), task);
                }
            }
        }
        return this.allTasks.get(taskName);
    }

    public static Pipeline extractPipeline(String name, AbstractProject<?, ?> firstProject, AbstractProject<?, ?> lastProject, boolean withUpstream) throws PipelineException {
        ArrayList stages = Lists.newArrayList(Stage.extractStages(firstProject, lastProject));
        if (withUpstream) {
            return new DownstreamPipeline(name, firstProject, lastProject, stages);
        }
        return new Pipeline(name, firstProject, lastProject, stages);
    }

    public static Pipeline extractPipeline(String name, AbstractProject<?, ?> firstProject) throws PipelineException {
        return Pipeline.extractPipeline(name, firstProject, null, false);
    }

    Pipeline createPipelineAggregatedWithoutChangesShown(ItemGroup context) {
        return this.createPipelineAggregated(context, false);
    }

    Pipeline createPipelineAggregatedWithChangesShown(ItemGroup context) {
        return this.createPipelineAggregated(context, true);
    }

    public Pipeline createPipelineAggregated(ItemGroup context, boolean showAggregatedChanges) {
        ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
        for (Stage stage : this.getStages()) {
            pipelineStages.add(stage.createAggregatedStage(context, this.firstProject));
        }
        if (showAggregatedChanges) {
            this.setAggregatedChanges(context, pipelineStages);
        }
        return new Pipeline(this.getName(), this.firstProject, this.lastProject, null, null, null, null, pipelineStages, true);
    }

    void setAggregatedChanges(ItemGroup context, List<Stage> pipelineStages) {
        for (int i = 0; i < pipelineStages.size() - 1; ++i) {
            Stage stage = pipelineStages.get(i);
            Stage nextStage = pipelineStages.get(i + 1);
            AbstractBuild nextBuild = nextStage.getHighestBuild(this.firstProject, context, Result.SUCCESS);
            HashSet changes = Sets.newHashSet();
            for (AbstractBuild build = stage.getHighestBuild(this.firstProject, context, Result.SUCCESS); build != null && build != nextBuild; build = build.getPreviousBuild()) {
                changes.addAll(Change.getChanges(build));
            }
            stage.setChanges(changes);
        }
    }

    public List<Pipeline> createPipelineLatest(int noOfPipelines, ItemGroup context, boolean pagingEnabled, boolean showChanges, Component component) throws PipelineException {
        ArrayList<Pipeline> result = new ArrayList<Pipeline>();
        if (this.firstProject.isInQueue()) {
            String pipeLineTimestamp = PipelineUtils.formatTimestamp(this.firstProject.getQueueItem().getInQueueSince());
            ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
            for (Stage stage : this.getStages()) {
                pipelineStages.add(stage.createLatestStage(context, null));
            }
            Pipeline pipelineLatest = new Pipeline(this.getName(), this.firstProject, this.lastProject, "#" + this.firstProject.getNextBuildNumber(), pipeLineTimestamp, TriggerCause.getTriggeredBy((Job)this.firstProject, null), null, pipelineStages, false);
            result.add(pipelineLatest);
        }
        int totalNoOfPipelines = this.firstProject.getBuilds().size();
        component.setTotalNoOfPipelines(totalNoOfPipelines);
        int startIndex = 0;
        int retrieveSize = noOfPipelines;
        if (pagingEnabled && !component.isFullScreenView()) {
            startIndex = (component.getCurrentPage() - 1) * noOfPipelines;
            retrieveSize = Math.min(totalNoOfPipelines - (component.getCurrentPage() - 1) * noOfPipelines, noOfPipelines);
        }
        ListIterator it = this.firstProject.getBuilds().listIterator(startIndex);
        result.addAll(this.getPipelines(it, context, startIndex, retrieveSize, showChanges));
        return result;
    }

    protected List<AbstractBuild> resolveBuilds(List<AbstractProject> firstProjects) {
        ArrayList<AbstractBuild> builds = new ArrayList<AbstractBuild>();
        for (AbstractProject firstProject : firstProjects) {
            builds.addAll((Collection<AbstractBuild>)firstProject.getBuilds());
        }
        Collections.sort(builds, new BuildStartTimeComparator());
        return builds;
    }

    protected List<Pipeline> getPipelines(Iterator it, ItemGroup context, int startIndex, int retrieveSize, boolean showChanges) throws PipelineException {
        ArrayList<Pipeline> result = new ArrayList<Pipeline>();
        for (int i = startIndex; i < startIndex + retrieveSize && it.hasNext(); ++i) {
            AbstractBuild firstBuild = (AbstractBuild)it.next();
            List<Change> pipelineChanges = Change.getChanges(firstBuild);
            Set<UserInfo> contributors = showChanges ? UserInfo.getContributors(pipelineChanges) : null;
            String pipeLineTimestamp = PipelineUtils.formatTimestamp(firstBuild.getTimeInMillis());
            ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
            Pipeline pipeline = this;
            if (this.showUpstream()) {
                pipeline = Pipeline.extractPipeline(this.getName(), firstBuild.getProject(), this.lastProject, this.showUpstream());
            }
            for (Stage stage : pipeline.getStages()) {
                pipelineStages.add(stage.createLatestStage(context, firstBuild));
            }
            Pipeline pipelineLatest = this.pipelineOf(firstBuild, this.lastProject, pipeLineTimestamp, contributors, pipelineStages);
            if (showChanges) {
                pipelineLatest.setChanges(pipelineChanges);
            }
            pipelineLatest.setCommits(pipelineChanges.size());
            pipelineLatest.calculateTotalBuildTime();
            result.add(pipelineLatest);
        }
        return result;
    }

    protected Pipeline pipelineOf(AbstractBuild firstBuild, AbstractProject lastProject, String pipeLineTimestamp, Set<UserInfo> contributors, List<Stage> pipelineStages) {
        return new Pipeline(this.getName(), firstBuild.getProject(), lastProject, firstBuild.getDisplayName(), pipeLineTimestamp, TriggerCause.getTriggeredBy((Job)firstBuild.getProject(), firstBuild), contributors, pipelineStages, false);
    }

    public boolean showUpstream() {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("name", (Object)this.getName()).add("version", (Object)this.getVersion()).add("stages", this.getStages()).toString();
    }

    @Exported
    public List<TriggerCause> getTriggeredBy() {
        return this.triggeredBy;
    }
}

