/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.PipelinePagination;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Pipeline;
import se.diabol.jenkins.pipeline.util.FullScreen;

@ExportedBean(defaultVisibility=100)
public class Component
extends AbstractItem {
    private List<Pipeline> pipelines;
    private final String firstJob;
    private final String firstJobUrl;
    private final boolean firstJobParameterized;
    private final int noOfPipelines;
    private int componentNumber = 0;
    private boolean pagingEnabled = false;
    private int totalNoOfPipelines = 0;

    public Component(String name, String firstJob, String firstJobUrl, boolean firstJobParameterized, int noOfPipelines, boolean pagingEnabled, int componentNumber) {
        super(name);
        this.firstJob = firstJob;
        this.firstJobUrl = firstJobUrl;
        this.firstJobParameterized = firstJobParameterized;
        this.noOfPipelines = noOfPipelines;
        this.pagingEnabled = pagingEnabled;
        this.componentNumber = componentNumber;
    }

    @Exported
    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    public void setPipelines(List<Pipeline> pipelines) {
        this.pipelines = ImmutableList.copyOf(pipelines);
    }

    @Exported
    public String getFirstJob() {
        return this.firstJob;
    }

    @Exported
    public String getFirstJobUrl() {
        return this.firstJobUrl;
    }

    @Exported
    public boolean isFirstJobParameterized() {
        return this.firstJobParameterized;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("pipelines", this.pipelines).toString();
    }

    @Exported
    public String getPagingData() {
        if (this.getPagination() == null) {
            return "";
        }
        return this.getPagination().getTag();
    }

    public int getTotalNoOfPipelines() {
        return this.totalNoOfPipelines;
    }

    public PipelinePagination getPagination() {
        if (this.pagingEnabled) {
            return new PipelinePagination(this.getCurrentPage(), this.totalNoOfPipelines, this.noOfPipelines, "?" + (this.isFullScreenView() ? "fullscreen=true&" : "fullscreen=false&") + "component=" + this.componentNumber + "&page=");
        }
        return null;
    }

    public int getCurrentPage() {
        int component;
        StaplerRequest req = Stapler.getCurrentRequest();
        int page = req == null ? 1 : (req.getParameter("page") == null ? 1 : Integer.parseInt(req.getParameter("page")));
        page = Math.max(page, 1);
        int n = req == null ? 1 : (component = req.getParameter("component") == null ? 1 : Integer.parseInt(req.getParameter("component")));
        if (component != this.componentNumber) {
            page = 1;
        }
        return page;
    }

    public boolean isFullScreenView() {
        return FullScreen.isFullScreenRequest(Stapler.getCurrentRequest());
    }

    @Exported
    public int getComponentNumber() {
        return this.componentNumber;
    }

    public void setTotalNoOfPipelines(int totalNoOfPipelines) {
        this.totalNoOfPipelines = totalNoOfPipelines;
    }
}

