/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

public class PipelineVersionContributor
extends BuildWrapper {
    public static final String VERSION_PARAMETER = "PIPELINE_VERSION";
    private final String versionTemplate;
    private boolean updateDisplayName = false;
    private static final Logger LOG = Logger.getLogger(PipelineVersionContributor.class.getName());

    @DataBoundConstructor
    public PipelineVersionContributor(boolean updateDisplayName, String versionTemplate) {
        this.updateDisplayName = updateDisplayName;
        this.versionTemplate = versionTemplate;
    }

    public String getVersionTemplate() {
        return this.versionTemplate;
    }

    public boolean isUpdateDisplayName() {
        return this.updateDisplayName;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        try {
            String version = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.getVersionTemplate());
            PipelineVersionContributor.setVersion(build, version);
            listener.getLogger().println("Creating version: " + version);
            if (this.isUpdateDisplayName()) {
                build.setDisplayName(version);
            }
        }
        catch (MacroEvaluationException e) {
            listener.getLogger().println("Error creating version: " + e.getMessage());
            LOG.log(Level.WARNING, "Error creating version", e);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    @CheckForNull
    public static String getVersion(AbstractBuild build) {
        PipelineVersionAction action = (PipelineVersionAction)build.getAction(PipelineVersionAction.class);
        if (action != null) {
            return action.getVersion();
        }
        return null;
    }

    static void setVersion(AbstractBuild build, String version) {
        PipelineVersionAction action = (PipelineVersionAction)build.getAction(PipelineVersionAction.class);
        if (action == null) {
            build.addAction((Action)new PipelineVersionAction(version));
        } else {
            build.replaceAction((Action)action);
        }
        build.replaceAction((Action)PipelineVersionContributor.getVersionParameterAction(build, version));
    }

    private static ParametersAction getVersionParameterAction(AbstractBuild build, String version) {
        StringParameterValue value = new StringParameterValue(VERSION_PARAMETER, version);
        ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
        if (action != null) {
            ArrayList<StringParameterValue> parameters = new ArrayList<StringParameterValue>(action.getParameters());
            parameters.add(value);
            return new ParametersAction(parameters);
        }
        return new ParametersAction(new ParameterValue[]{value});
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Create Delivery Pipeline version";
        }
    }

    static class PipelineVersionAction
    extends CauseAction {
        private final String version;

        PipelineVersionAction(String version) {
            super(new Cause[0]);
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

