/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

public class PipelinePagination {
    private int totalCount = 0;
    private int currentPage = 1;
    private int prevPage = 0;
    private int nextPage = 0;
    private int totalPage = 0;
    private int pageSize = 10;
    private final String moveLink;

    public PipelinePagination(int currentPage, int totalCount, int pagingSize, String moveLink) {
        this.currentPage = currentPage;
        this.totalCount = totalCount;
        this.pageSize = pagingSize == 0 ? 10 : pagingSize;
        this.moveLink = moveLink;
    }

    public String getTag() {
        this.setPagination();
        StringBuilder sb = new StringBuilder();
        if (this.prevPage + 1 > 10) {
            this.setPrePage(sb);
        }
        this.setIndex(sb);
        if (this.totalPage > this.prevPage + 10) {
            this.setNextPage(sb);
        }
        return sb.toString();
    }

    private void setNextPage(StringBuilder sb) {
        sb.append("<a href='").append(this.moveLink).append(this.nextPage).append("'>\n").append("Next").append("</a>\n");
    }

    private void setPrePage(StringBuilder sb) {
        sb.append("<a href='").append(this.moveLink).append(this.prevPage).append("'>\n").append("Prev").append("</a>\n");
    }

    private void setIndex(StringBuilder sb) {
        for (int count = this.prevPage + 1; count < this.nextPage && count <= this.totalPage; ++count) {
            if (count == this.currentPage) {
                sb.append("<span");
                sb.append(" class='active_link'>\n");
                sb.append("<a>").append(count).append("</a>\n");
                sb.append("</span>\n");
                continue;
            }
            sb.append("<a href='").append(this.moveLink).append(count).append("'>").append(count).append("</a>\n");
        }
    }

    private void setPagination() {
        int current = (this.currentPage - 1) / 10 + 1;
        this.prevPage = (current - 1) * 10;
        this.nextPage = current * 10 + 1;
        this.totalPage = (this.totalCount - 1) / this.pageSize + 1;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

