/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import com.google.common.collect.Sets;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ParametersAction;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.model.listeners.ItemListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.PipelineApi;
import se.diabol.jenkins.pipeline.domain.Component;
import se.diabol.jenkins.pipeline.domain.Pipeline;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.sort.ComponentComparator;
import se.diabol.jenkins.pipeline.sort.ComponentComparatorDescriptor;
import se.diabol.jenkins.pipeline.trigger.ManualTrigger;
import se.diabol.jenkins.pipeline.trigger.ManualTriggerFactory;
import se.diabol.jenkins.pipeline.trigger.TriggerException;
import se.diabol.jenkins.pipeline.util.FullScreen;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

public class DeliveryPipelineView
extends View {
    private static final Logger LOG = Logger.getLogger(DeliveryPipelineView.class.getName());
    private static final int DEFAULT_INTERVAL = 2;
    private static final int DEFAULT_NO_OF_PIPELINES = 3;
    private static final int MAX_NO_OF_PIPELINES = 50;
    private static final String OLD_NONE_SORTER = "se.diabol.jenkins.pipeline.sort.NoOpComparator";
    private static final String NONE_SORTER = "none";
    public static final String DEFAULT_THEME = "default";
    private List<ComponentSpec> componentSpecs;
    private int noOfPipelines = 3;
    private boolean showAggregatedPipeline = false;
    private int noOfColumns = 1;
    private String sorting = "none";
    private String fullScreenCss = null;
    private String embeddedCss = null;
    private boolean showAvatars = false;
    private int updateInterval = 2;
    private boolean showChanges = false;
    private boolean allowManualTriggers = false;
    private boolean showTotalBuildTime = false;
    private boolean allowRebuild = false;
    private boolean allowPipelineStart = false;
    private boolean showDescription = false;
    private boolean showPromotions = false;
    private boolean showTestResults = false;
    private boolean showStaticAnalysisResults = false;
    private boolean linkRelative = false;
    private boolean pagingEnabled = false;
    private boolean showAggregatedChanges = false;
    private String aggregatedChangesGroupingPattern = null;
    private String theme = "default";
    private int maxNumberOfVisiblePipelines = -1;
    private List<RegExpSpec> regexpFirstJobs;
    private boolean linkToConsoleLog = false;
    private String description = null;
    private transient String error;

    @DataBoundConstructor
    public DeliveryPipelineView(String name) {
        super(name);
    }

    public DeliveryPipelineView(String name, ViewGroup owner) {
        super(name, owner);
    }

    public List<RegExpSpec> getRegexpFirstJobs() {
        return this.regexpFirstJobs;
    }

    public void setRegexpFirstJobs(List<RegExpSpec> regexpFirstJobs) {
        this.regexpFirstJobs = regexpFirstJobs;
    }

    public boolean getShowAvatars() {
        return this.showAvatars;
    }

    public void setShowAvatars(boolean showAvatars) {
        this.showAvatars = showAvatars;
    }

    public String getSorting() {
        if (OLD_NONE_SORTER.equals(this.sorting)) {
            this.sorting = NONE_SORTER;
        }
        return this.sorting;
    }

    public void setSorting(String sorting) {
        this.sorting = OLD_NONE_SORTER.equals(sorting) ? NONE_SORTER : sorting;
    }

    public List<ComponentSpec> getComponentSpecs() {
        return this.componentSpecs;
    }

    public void setComponentSpecs(List<ComponentSpec> componentSpecs) {
        this.componentSpecs = componentSpecs;
    }

    public int getNoOfPipelines() {
        return this.noOfPipelines;
    }

    public boolean isShowAggregatedPipeline() {
        return this.showAggregatedPipeline;
    }

    public void setNoOfPipelines(int noOfPipelines) {
        this.noOfPipelines = noOfPipelines;
    }

    public boolean isShowChanges() {
        return this.showChanges;
    }

    public void setShowChanges(boolean showChanges) {
        this.showChanges = showChanges;
    }

    @Exported
    public boolean isShowTotalBuildTime() {
        return this.showTotalBuildTime;
    }

    public void setShowTotalBuildTime(boolean showTotalBuildTime) {
        this.showTotalBuildTime = showTotalBuildTime;
    }

    public void setShowAggregatedPipeline(boolean showAggregatedPipeline) {
        this.showAggregatedPipeline = showAggregatedPipeline;
    }

    @Exported
    public boolean isAllowPipelineStart() {
        return this.allowPipelineStart;
    }

    public void setAllowPipelineStart(boolean allowPipelineStart) {
        this.allowPipelineStart = allowPipelineStart;
    }

    @Exported
    public boolean isAllowManualTriggers() {
        return this.allowManualTriggers;
    }

    public void setAllowManualTriggers(boolean allowManualTriggers) {
        this.allowManualTriggers = allowManualTriggers;
    }

    public int getNoOfColumns() {
        return this.noOfColumns;
    }

    public void setNoOfColumns(int noOfColumns) {
        this.noOfColumns = noOfColumns;
    }

    public String getFullScreenCss() {
        return this.fullScreenCss;
    }

    public int getUpdateInterval() {
        if (this.updateInterval == 0) {
            this.updateInterval = 2;
        }
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public void setFullScreenCss(String fullScreenCss) {
        this.fullScreenCss = fullScreenCss != null && "".equals(fullScreenCss.trim()) ? null : fullScreenCss;
    }

    public String getEmbeddedCss() {
        return this.embeddedCss;
    }

    public void setEmbeddedCss(String embeddedCss) {
        this.embeddedCss = embeddedCss != null && "".equals(embeddedCss.trim()) ? null : embeddedCss;
    }

    @Exported
    public boolean getPagingEnabled() {
        return this.pagingEnabled;
    }

    public String getTheme() {
        return this.theme == null ? DEFAULT_THEME : this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public boolean isFullScreenView() {
        return FullScreen.isFullScreenRequest(Stapler.getCurrentRequest());
    }

    public void onProjectRenamed(Item item, String oldName, String newName) {
        if (this.componentSpecs != null) {
            Iterator<ComponentSpec> it = this.componentSpecs.iterator();
            while (it.hasNext()) {
                ComponentSpec componentSpec = it.next();
                if (componentSpec.getFirstJob().equals(oldName)) {
                    if (newName == null) {
                        it.remove();
                    } else {
                        componentSpec.setFirstJob(newName);
                    }
                }
                if (componentSpec.getLastJob() == null || !componentSpec.getLastJob().equals(oldName)) continue;
                if (newName == null) {
                    it.remove();
                    continue;
                }
                componentSpec.setLastJob(newName);
            }
        }
    }

    @Exported
    public String getViewUrl() {
        return super.getViewUrl();
    }

    public Api getApi() {
        return new PipelineApi(this);
    }

    @Exported
    public String getLastUpdated() {
        return PipelineUtils.formatTimestamp(System.currentTimeMillis());
    }

    @Exported
    public String getError() {
        return this.error;
    }

    @Exported
    public boolean isAllowRebuild() {
        return this.allowRebuild;
    }

    public void setAllowRebuild(boolean allowRebuild) {
        this.allowRebuild = allowRebuild;
    }

    @Exported
    public boolean isShowDescription() {
        return this.showDescription;
    }

    @Exported
    public boolean isShowPromotions() {
        return this.showPromotions;
    }

    @Exported
    public boolean isShowTestResults() {
        return this.showTestResults;
    }

    @Exported
    public boolean isShowStaticAnalysisResults() {
        return this.showStaticAnalysisResults;
    }

    @Exported
    public boolean isLinkRelative() {
        return this.linkRelative;
    }

    public void setLinkRelative(boolean linkRelative) {
        this.linkRelative = linkRelative;
    }

    public void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    public void setShowPromotions(boolean showPromotions) {
        this.showPromotions = showPromotions;
    }

    public void setShowTestResults(boolean showTestResults) {
        this.showTestResults = showTestResults;
    }

    public void setShowStaticAnalysisResults(boolean showStaticAnalysisResults) {
        this.showStaticAnalysisResults = showStaticAnalysisResults;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.pagingEnabled = pagingEnabled;
    }

    @Exported
    public boolean isShowAggregatedChanges() {
        return this.showAggregatedChanges;
    }

    public void setShowAggregatedChanges(boolean showAggregatedChanges) {
        this.showAggregatedChanges = showAggregatedChanges;
    }

    @Exported
    public String getAggregatedChangesGroupingPattern() {
        return this.aggregatedChangesGroupingPattern;
    }

    public void setAggregatedChangesGroupingPattern(String aggregatedChangesGroupingPattern) {
        this.aggregatedChangesGroupingPattern = aggregatedChangesGroupingPattern;
    }

    public int getMaxNumberOfVisiblePipelines() {
        return this.maxNumberOfVisiblePipelines;
    }

    public void setMaxNumberOfVisiblePipelines(int maxNumberOfVisiblePipelines) {
        this.maxNumberOfVisiblePipelines = maxNumberOfVisiblePipelines;
    }

    @Exported
    public boolean isLinkToConsoleLog() {
        return this.linkToConsoleLog;
    }

    public void setLinkToConsoleLog(boolean linkToConsoleLog) {
        this.linkToConsoleLog = linkToConsoleLog;
    }

    @Exported
    public String getDescription() {
        if (((View)this).description == null) {
            this.setDescription(this.description);
        }
        return ((View)this).description;
    }

    public void setDescription(String description) {
        ((View)this).description = description;
        this.description = description;
    }

    @JavaScriptMethod
    public void triggerManual(String projectName, String upstreamName, String buildId) throws TriggerException, AuthenticationException {
        try {
            LOG.fine("Trigger manual build " + projectName + " " + upstreamName + " " + buildId);
            AbstractProject<?, ?> project = ProjectUtil.getProject(projectName, (ItemGroup)Jenkins.getInstance());
            if (!project.hasPermission(Item.BUILD)) {
                throw new BadCredentialsException("Not authorized to trigger build");
            }
            AbstractProject<?, ?> upstream = ProjectUtil.getProject(upstreamName, (ItemGroup)Jenkins.getInstance());
            ManualTrigger trigger = ManualTriggerFactory.getManualTrigger(project, upstream);
            if (trigger == null) {
                String message = "Trigger not found for manual build " + projectName + " for upstream " + upstreamName + " id: " + buildId;
                LOG.log(Level.WARNING, message);
                throw new TriggerException(message);
            }
            trigger.triggerManual(project, upstream, buildId, (ItemGroup<? extends TopLevelItem>)this.getOwner().getItemGroup());
        }
        catch (TriggerException e) {
            LOG.log(Level.WARNING, DeliveryPipelineView.triggerExceptionMessage(projectName, upstreamName, buildId), e);
            throw e;
        }
    }

    public void triggerRebuild(String projectName, String buildId) {
        AbstractProject<?, ?> project = ProjectUtil.getProject(projectName, (ItemGroup)Jenkins.getInstance());
        if (!project.hasPermission(Item.BUILD)) {
            throw new BadCredentialsException("Not authorized to trigger build");
        }
        AbstractBuild build = project.getBuildByNumber(Integer.parseInt(buildId));
        List prevCauses = build.getCauses();
        ArrayList<Object> newCauses = new ArrayList<Object>();
        for (Cause cause : prevCauses) {
            if (cause instanceof Cause.UserIdCause) continue;
            newCauses.add(cause);
        }
        newCauses.add(new Cause.UserIdCause());
        CauseAction causeAction = new CauseAction(newCauses);
        project.scheduleBuild2(project.getQuietPeriod(), null, new Action[]{causeAction, build.getAction(ParametersAction.class)});
    }

    protected static String triggerExceptionMessage(String projectName, String upstreamName, String buildId) {
        String message = "Could not trigger manual build " + projectName + " for upstream " + upstreamName + " id: " + buildId;
        if (projectName.contains("/")) {
            message = message + ". Did you mean to specify " + DeliveryPipelineView.withoutFolderPrefix(projectName) + "?";
        }
        return message;
    }

    protected static String withoutFolderPrefix(String projectName) {
        return projectName.substring(projectName.indexOf("/") + 1);
    }

    @Exported
    public List<Component> getPipelines() {
        try {
            ComponentComparatorDescriptor comparatorDescriptor;
            LOG.fine("Getting pipelines!");
            List<Component> components = new ArrayList<Component>();
            if (this.componentSpecs != null) {
                for (ComponentSpec componentSpec : this.componentSpecs) {
                    AbstractProject<?, ?> firstJob = ProjectUtil.getProject(componentSpec.getFirstJob(), this.getOwnerItemGroup());
                    AbstractProject<?, ?> lastJob = ProjectUtil.getProject(componentSpec.getLastJob(), this.getOwnerItemGroup());
                    if (firstJob != null) {
                        components.add(this.getComponent(componentSpec.getName(), firstJob, lastJob, this.showAggregatedPipeline, this.componentSpecs.indexOf((Object)componentSpec) + 1, componentSpec.isShowUpstream()));
                        continue;
                    }
                    throw new PipelineException("Could not find project: " + componentSpec.getFirstJob());
                }
            }
            if (this.regexpFirstJobs != null) {
                for (RegExpSpec regexp : this.regexpFirstJobs) {
                    Map<String, AbstractProject> matches = ProjectUtil.getProjects(regexp.getRegexp());
                    int index = 1;
                    for (Map.Entry<String, AbstractProject> entry : matches.entrySet()) {
                        components.add(this.getComponent(entry.getKey(), entry.getValue(), null, this.showAggregatedPipeline, index, regexp.isShowUpstream()));
                        ++index;
                    }
                }
            }
            if (this.getSorting() != null && !this.getSorting().equals(NONE_SORTER) && (comparatorDescriptor = (ComponentComparatorDescriptor)ComponentComparator.all().find(this.sorting)) != null) {
                Collections.sort(components, comparatorDescriptor.createInstance());
            }
            if (this.maxNumberOfVisiblePipelines > 0) {
                LOG.fine("Limiting number of jobs to: " + this.maxNumberOfVisiblePipelines);
                components = components.subList(0, Math.min(components.size(), this.maxNumberOfVisiblePipelines));
            }
            LOG.fine("Returning: " + components);
            this.error = null;
            return components;
        }
        catch (PipelineException e) {
            this.error = e.getMessage();
            return new ArrayList<Component>();
        }
    }

    private Component getComponent(String name, AbstractProject firstJob, AbstractProject lastJob, boolean showAggregatedPipeline, int componentNumber, boolean showUpstream) throws PipelineException {
        Pipeline pipeline = Pipeline.extractPipeline(name, firstJob, lastJob, showUpstream);
        Component component = new Component(name, firstJob.getName(), firstJob.getUrl(), firstJob.isParameterized(), this.noOfPipelines, this.pagingEnabled, componentNumber);
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        if (showAggregatedPipeline) {
            pipelines.add(pipeline.createPipelineAggregated(this.getOwnerItemGroup(), this.showAggregatedChanges));
        }
        pipelines.addAll(pipeline.createPipelineLatest(this.noOfPipelines, this.getOwnerItemGroup(), this.showPaging(), this.showChanges, component));
        component.setPipelines(pipelines);
        return component;
    }

    protected boolean showPaging() {
        return !this.isFullScreenView() && this.getPagingEnabled();
    }

    public Collection<TopLevelItem> getItems() {
        HashSet jobs = Sets.newHashSet();
        this.addJobsFromComponentSpecs(jobs);
        this.addRegexpFirstJobs(jobs);
        return jobs;
    }

    private void addJobsFromComponentSpecs(Set<TopLevelItem> jobs) {
        if (this.componentSpecs == null) {
            return;
        }
        for (ComponentSpec spec : this.componentSpecs) {
            AbstractProject<?, ?> first = ProjectUtil.getProject(spec.getFirstJob(), this.getOwnerItemGroup());
            AbstractProject<?, ?> last = ProjectUtil.getProject(spec.getLastJob(), this.getOwnerItemGroup());
            Collection<AbstractProject<?, ?>> downstreamProjects = ProjectUtil.getAllDownstreamProjects(first, last).values();
            for (AbstractProject<?, ?> project : downstreamProjects) {
                jobs.add((TopLevelItem)project);
            }
        }
    }

    private void addRegexpFirstJobs(Set<TopLevelItem> jobs) {
        if (this.regexpFirstJobs == null) {
            return;
        }
        for (RegExpSpec spec : this.regexpFirstJobs) {
            Map<String, AbstractProject> regexpJobs = ProjectUtil.getProjects(spec.getRegexp());
            for (AbstractProject project : regexpJobs.values()) {
                jobs.add((TopLevelItem)project);
            }
        }
    }

    public boolean contains(TopLevelItem item) {
        return this.getItems().contains(item);
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        req.bindJSON((Object)this, req.getSubmittedForm());
        this.componentSpecs = req.bindJSONToList(ComponentSpec.class, req.getSubmittedForm().get("componentSpecs"));
        this.regexpFirstJobs = req.bindJSONToList(RegExpSpec.class, req.getSubmittedForm().get("regexpFirstJobs"));
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.isDefault()) {
            return this.getOwner().getPrimaryView().doCreateItem(req, rsp);
        }
        return JenkinsUtil.getInstance().doCreateItem(req, rsp);
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            this.notifyView(item, oldName, newName);
        }

        public void onDeleted(Item item) {
            this.notifyView(item, item.getFullName(), null);
        }

        private void notifyView(Item item, String oldName, String newName) {
            Collection views = JenkinsUtil.getInstance().getViews();
            for (View view : views) {
                if (!(view instanceof DeliveryPipelineView)) continue;
                ((DeliveryPipelineView)view).onProjectRenamed(item, oldName, newName);
            }
        }
    }

    public static class ComponentSpec
    extends AbstractDescribableImpl<ComponentSpec> {
        private String name;
        private String firstJob;
        private String lastJob;
        private boolean showUpstream;

        @DataBoundConstructor
        public ComponentSpec(String name, String firstJob, String lastJob, boolean showUpstream) {
            this.name = name;
            this.firstJob = firstJob;
            this.lastJob = lastJob;
            this.showUpstream = showUpstream;
        }

        public String getName() {
            return this.name;
        }

        public String getFirstJob() {
            return this.firstJob;
        }

        public void setFirstJob(String firstJob) {
            this.firstJob = firstJob;
        }

        public String getLastJob() {
            return this.lastJob;
        }

        public void setLastJob(String lastJob) {
            this.lastJob = lastJob;
        }

        public boolean isShowUpstream() {
            return this.showUpstream;
        }

        public void setShowUpstream(boolean showUpstream) {
            this.showUpstream = showUpstream;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<ComponentSpec> {
            @Nonnull
            public String getDisplayName() {
                return "";
            }

            public ListBoxModel doFillFirstJobItems(@AncestorInPath ItemGroup<?> context) {
                return ProjectUtil.fillAllProjects(context, AbstractProject.class);
            }

            public ListBoxModel doFillLastJobItems(@AncestorInPath ItemGroup<?> context) {
                ListBoxModel options = new ListBoxModel();
                options.add("");
                options.addAll((Collection)ProjectUtil.fillAllProjects(context, AbstractProject.class));
                return options;
            }

            public FormValidation doCheckName(@QueryParameter String value) {
                if (value != null && !"".equals(value.trim())) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Please supply a title");
            }
        }
    }

    public static class RegExpSpec
    extends AbstractDescribableImpl<RegExpSpec> {
        private String regexp;
        private boolean showUpstream;

        @DataBoundConstructor
        public RegExpSpec(String regexp, boolean showUpstream) {
            this.regexp = regexp;
            this.showUpstream = showUpstream;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public boolean isShowUpstream() {
            return this.showUpstream;
        }

        public void setShowUpstream(boolean showUpstream) {
            this.showUpstream = showUpstream;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<RegExpSpec> {
            @Nonnull
            public String getDisplayName() {
                return "RegExp";
            }

            public FormValidation doCheckRegexp(@QueryParameter String value) {
                if (value != null) {
                    try {
                        Pattern pattern = Pattern.compile(value);
                        if (pattern.matcher("").groupCount() == 1) {
                            return FormValidation.ok();
                        }
                        if (pattern.matcher("").groupCount() == 0) {
                            return FormValidation.error((String)"No capture group defined");
                        }
                        return FormValidation.error((String)"Too many capture groups defined");
                    }
                    catch (PatternSyntaxException e) {
                        return FormValidation.error((Throwable)e, (String)"Syntax error in regular-expression pattern");
                    }
                }
                return FormValidation.ok();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ViewDescriptor {
        public ListBoxModel doFillNoOfColumnsItems(@AncestorInPath ItemGroup<?> context) {
            ListBoxModel options = new ListBoxModel();
            options.add("1", "1");
            options.add("2", "2");
            options.add("3", "3");
            return options;
        }

        public ListBoxModel doFillNoOfPipelinesItems(@AncestorInPath ItemGroup<?> context) {
            ListBoxModel options = new ListBoxModel();
            for (int i = 0; i <= 50; ++i) {
                String opt = String.valueOf(i);
                options.add(opt, opt);
            }
            return options;
        }

        public ListBoxModel doFillSortingItems() {
            DescriptorExtensionList<ComponentComparator, ComponentComparatorDescriptor> descriptors = ComponentComparator.all();
            ListBoxModel options = new ListBoxModel();
            options.add("None", DeliveryPipelineView.NONE_SORTER);
            for (ComponentComparatorDescriptor descriptor : descriptors) {
                options.add(descriptor.getDisplayName(), descriptor.getId());
            }
            return options;
        }

        public FormValidation doCheckUpdateInterval(@QueryParameter String value) {
            int valueAsInt;
            try {
                valueAsInt = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((Throwable)e, (String)"Value must be an integer");
            }
            if (valueAsInt <= 0) {
                return FormValidation.error((String)"Value must be greater than 0");
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Delivery Pipeline View";
        }
    }
}

