/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.util;

import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.util.ListBoxModel;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import se.diabol.jenkins.pipeline.RelationshipResolver;
import se.diabol.jenkins.pipeline.util.BuildUtil;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;

public final class ProjectUtil {
    private static final Logger LOG = Logger.getLogger(ProjectUtil.class.getName());

    private ProjectUtil() {
    }

    public static ListBoxModel fillAllProjects(ItemGroup<?> context) {
        ListBoxModel options = new ListBoxModel();
        for (AbstractProject p : JenkinsUtil.getInstance().getAllItems(AbstractProject.class)) {
            options.add(p.getFullDisplayName(), p.getRelativeNameFrom(context));
        }
        return options;
    }

    public static Map<String, AbstractProject<?, ?>> getAllDownstreamProjects(AbstractProject first, AbstractProject last) {
        LinkedHashMap projects = Maps.newLinkedHashMap();
        return ProjectUtil.getAllDownstreamProjects(first, last, projects);
    }

    public static Map<String, AbstractProject<?, ?>> getAllDownstreamProjects(AbstractProject first, AbstractProject last, Map<String, AbstractProject<?, ?>> projects) {
        if (first == null) {
            return projects;
        }
        if (projects.containsValue(first)) {
            return projects;
        }
        if (last != null && first.getFullName().equals(last.getFullName())) {
            projects.put(last.getFullName(), last);
            return projects;
        }
        projects.put(first.getFullName(), first);
        for (AbstractProject p : ProjectUtil.getDownstreamProjects(first)) {
            projects.putAll(ProjectUtil.getAllDownstreamProjects(p, last, projects));
        }
        return projects;
    }

    public static List<AbstractProject> getDownstreamProjects(AbstractProject<?, ?> project) {
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        List<RelationshipResolver> resolvers = RelationshipResolver.all();
        for (RelationshipResolver resolver : resolvers) {
            result.addAll(resolver.getDownstreamProjects(project));
        }
        return result;
    }

    public static AbstractProject<?, ?> getProject(String name, ItemGroup context) {
        return (AbstractProject)JenkinsUtil.getInstance().getItem(name, context, AbstractProject.class);
    }

    public static Map<String, AbstractProject> getProjects(String regExp) {
        try {
            Pattern pattern = Pattern.compile(regExp);
            HashMap<String, AbstractProject> result = new HashMap<String, AbstractProject>();
            for (AbstractProject project : JenkinsUtil.getInstance().getAllItems(AbstractProject.class)) {
                Matcher matcher = pattern.matcher(project.getFullName());
                if (!matcher.find()) continue;
                if (matcher.groupCount() >= 1) {
                    String name = matcher.group(1);
                    result.put(name, project);
                    continue;
                }
                LOG.log(Level.WARNING, "Could not find match group");
            }
            return result;
        }
        catch (PatternSyntaxException e) {
            LOG.log(Level.WARNING, "Could not find projects on regular expression", e);
            return Collections.emptyMap();
        }
    }

    public static boolean isQueued(AbstractProject project, AbstractBuild firstBuild) {
        if (project.isInQueue()) {
            if (firstBuild == null) {
                return true;
            }
            List causes = Util.filter((List)project.getQueueItem().getCauses(), Cause.UpstreamCause.class);
            List upstreamProjects = project.getUpstreamProjects();
            for (AbstractProject upstreamProject : upstreamProjects) {
                AbstractBuild upstreamBuild = BuildUtil.match((RunList<? extends AbstractBuild>)upstreamProject.getBuilds(), firstBuild);
                if (upstreamBuild == null) continue;
                for (Cause.UpstreamCause upstreamCause : causes) {
                    if (upstreamBuild.getNumber() != upstreamCause.getUpstreamBuild() || !upstreamProject.getRelativeNameFrom((ItemGroup)JenkinsUtil.getInstance()).equals(upstreamCause.getUpstreamProject())) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static List<AbstractProject> getProjectList(String projects, ItemGroup context, EnvVars env) {
        ArrayList<AbstractProject> projectList = new ArrayList<AbstractProject>();
        StringBuilder projectNames = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(projects, ",");
        while (tokens.hasMoreTokens()) {
            if (projectNames.length() > 0) {
                projectNames.append(',');
            }
            projectNames.append(env != null ? env.expand(tokens.nextToken().trim()) : tokens.nextToken().trim());
        }
        projectList.addAll(Items.fromNameList((ItemGroup)context, (String)projectNames.toString(), AbstractProject.class));
        return projectList;
    }
}

