/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.util;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.util.RunList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;

public final class BuildUtil {
    private BuildUtil() {
    }

    @CheckForNull
    public static AbstractBuild getUpstreamBuild(AbstractBuild build) {
        List actions = build.getActions(CauseAction.class);
        for (CauseAction action : actions) {
            List causes = Util.filter((List)action.getCauses(), Cause.UpstreamCause.class);
            Iterator i$ = causes.iterator();
            if (!i$.hasNext()) continue;
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)i$.next();
            AbstractProject upstreamProject = (AbstractProject)JenkinsUtil.getInstance().getItemByFullName(upstreamCause.getUpstreamProject(), AbstractProject.class);
            if (upstreamProject == null) {
                return null;
            }
            return upstreamProject.getBuildByNumber(upstreamCause.getUpstreamBuild());
        }
        return null;
    }

    @CheckForNull
    public static AbstractBuild getFirstUpstreamBuild(AbstractBuild build, AbstractProject first) {
        if (build == null) {
            return null;
        }
        if (build.getProject().equals(first)) {
            return build;
        }
        AbstractBuild upstreamBuild = BuildUtil.getUpstreamBuild(build);
        if (upstreamBuild != null) {
            if (upstreamBuild.getProject().equals(first)) {
                return upstreamBuild;
            }
            return BuildUtil.getFirstUpstreamBuild(upstreamBuild, first);
        }
        return build;
    }

    @CheckForNull
    public static AbstractBuild match(RunList<? extends AbstractBuild> runList, AbstractBuild firstBuild) {
        if (firstBuild != null) {
            for (AbstractBuild currentBuild : runList) {
                AbstractBuild build = BuildUtil.getFirstUpstreamBuild(currentBuild, firstBuild.getProject());
                if (!BuildUtil.equals(build, firstBuild)) continue;
                return currentBuild;
            }
        }
        return null;
    }

    public static boolean equals(AbstractBuild b1, AbstractBuild b2) {
        return b1 != null && b2 != null && b1.getProject().getFullName().equals(b2.getProject().getFullName()) && b1.getNumber() == b2.getNumber();
    }
}

