/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.token;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public final class TokenUtils {
    private static final Logger LOG = Logger.getLogger(TokenUtils.class.getName());
    private static final String MESSAGE = "Error during decoding template - ";

    private TokenUtils() {
    }

    public static String decodedTemplate(AbstractBuild<?, ?> build, String template) {
        try {
            if (build != null) {
                return TokenMacro.expandAll(build, (TaskListener)TaskListener.NULL, (String)template);
            }
            return template.replaceAll("\\$\\{.*?\\}", "...");
        }
        catch (MacroEvaluationException e) {
            LOG.log(Level.WARNING, e.getMessage());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, MESSAGE + e.getMessage());
        }
        return "";
    }

    public static boolean stringIsNotEmpty(String string) {
        if (string == null || "".equals(string)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

