/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.resolver;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import se.diabol.jenkins.pipeline.CauseResolver;
import se.diabol.jenkins.pipeline.domain.TriggerCause;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;

@Extension(ordinal=1000.0)
public class CoreCauseResolver
extends CauseResolver {
    @Override
    public TriggerCause resolveCause(Cause cause) {
        if (cause instanceof Cause.UserIdCause) {
            return new TriggerCause("MANUAL", "user " + CoreCauseResolver.getDisplayName(((Cause.UserIdCause)cause).getUserName()));
        }
        if (cause instanceof Cause.RemoteCause) {
            return new TriggerCause("REMOTE", "remote trigger");
        }
        if (cause instanceof Cause.UpstreamCause) {
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
            AbstractProject upstreamProject = (AbstractProject)JenkinsUtil.getInstance().getItem(upstreamCause.getUpstreamProject(), (ItemGroup)JenkinsUtil.getInstance(), AbstractProject.class);
            StringBuilder causeString = new StringBuilder("upstream project");
            if (upstreamProject != null) {
                causeString.append(" ").append(upstreamProject.getDisplayName());
                AbstractBuild upstreamBuild = upstreamProject.getBuildByNumber(upstreamCause.getUpstreamBuild());
                if (upstreamBuild != null) {
                    causeString.append(" build ").append(upstreamBuild.getDisplayName());
                }
            }
            return new TriggerCause("UPSTREAM", causeString.toString());
        }
        if (cause instanceof Cause.UpstreamCause.DeeplyNestedUpstreamCause) {
            return new TriggerCause("UPSTREAM", "upstream");
        }
        if (cause instanceof SCMTrigger.SCMTriggerCause) {
            return new TriggerCause("SCM", "SCM");
        }
        if (cause instanceof TimerTrigger.TimerTriggerCause) {
            return new TriggerCause("TIMER", "timer");
        }
        return null;
    }

    protected static String getDisplayName(String userName) {
        User user = JenkinsUtil.getInstance().getUser(userName);
        if (user != null) {
            return user.getDisplayName();
        }
        return "anonymous";
    }
}

