/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.status.promotion;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BooleanParameterValue;
import hudson.model.FileParameterValue;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import se.diabol.jenkins.pipeline.domain.status.promotion.AbstractPromotionStatusProvider;
import se.diabol.jenkins.pipeline.domain.status.promotion.PromotionStatus;

@Extension(optional=true)
public class PromotionStatusProvider
extends AbstractPromotionStatusProvider {
    public static final Class<PromotedBuildAction> CLASS = PromotedBuildAction.class;
    static final String DEFAULT_ICON_SIZE = "16x16";
    private PromotionStatusWrapper promotionStatusWrapper = new PromotionStatusWrapper();
    private PromotedBuildActionWrapper promotedBuildActionWrapper = new PromotedBuildActionWrapper();

    @Override
    public boolean isBuildPromoted(AbstractBuild<?, ?> build) {
        Action action = build.getAction(PromotedBuildAction.class);
        if (action != null) {
            return CollectionUtils.isNotEmpty(this.promotedBuildActionWrapper.getPromotions(action));
        }
        return false;
    }

    @Override
    public List<PromotionStatus> getPromotionStatusList(AbstractBuild<?, ?> build) {
        ArrayList<PromotionStatus> promotionStatusList = new ArrayList<PromotionStatus>();
        Action action = build.getAction(PromotedBuildAction.class);
        if (action != null) {
            for (Status status : this.promotedBuildActionWrapper.getPromotions(action)) {
                ArrayList<String> params = new ArrayList<String>();
                for (Promotion promotion : this.promotionStatusWrapper.getPromotionBuilds(status)) {
                    this.populatePromotionParameters(params, promotion);
                    promotionStatusList.add(this.buildNewPromotionStatus(build, status, params, promotion));
                }
            }
            this.sortPromotionStatusListByStartTimeInDescOrder(promotionStatusList);
        }
        return promotionStatusList;
    }

    private PromotionStatus buildNewPromotionStatus(AbstractBuild<?, ?> build, Object status, List<String> params, Object promotionObj) {
        Promotion promotion = (Promotion)promotionObj;
        String name = this.promotionStatusWrapper.getName(status);
        long startTime = promotion.getStartTimeInMillis();
        long duration = promotion.getTime().getTime() - build.getTimeInMillis();
        String userName = promotion.getUserName();
        String icon = this.promotionStatusWrapper.getIcon(status, DEFAULT_ICON_SIZE);
        return new PromotionStatus(name, startTime, duration, userName, icon, params);
    }

    private void populatePromotionParameters(List<String> params, Object promotionObj) {
        Promotion promotion = (Promotion)promotionObj;
        for (ParameterValue value : promotion.getParameterValues()) {
            if (value instanceof StringParameterValue) {
                if (!StringUtils.isNotBlank((String)((StringParameterValue)value).value)) continue;
                params.add("<strong>" + value.getName() + "</strong>: " + ((StringParameterValue)value).value);
                continue;
            }
            if (value instanceof FileParameterValue) {
                params.add("<strong>" + value.getName() + "</strong>: " + ((FileParameterValue)value).getLocation());
                continue;
            }
            if (!(value instanceof BooleanParameterValue) || !((BooleanParameterValue)value).value) continue;
            params.add("<strong>" + value.getName() + "</strong>: " + Boolean.toString(((BooleanParameterValue)value).value));
        }
    }

    private void sortPromotionStatusListByStartTimeInDescOrder(List<PromotionStatus> promotionStatusList) {
        Collections.sort(promotionStatusList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return (int)(PromotionStatusProvider.this.promotionStatusWrapper.getStartTime(o2) - PromotionStatusProvider.this.promotionStatusWrapper.getStartTime(o1));
            }
        });
    }

    void setPromotionStatusWrapper(PromotionStatusWrapper promotionStatusWrapper) {
        this.promotionStatusWrapper = promotionStatusWrapper;
    }

    void setPromotedBuildActionWrapper(PromotedBuildActionWrapper promotedBuildActionWrapper) {
        this.promotedBuildActionWrapper = promotedBuildActionWrapper;
    }

    static class PromotionStatusWrapper {
        PromotionStatusWrapper() {
        }

        public Collection<Promotion> getPromotionBuilds(Object status) {
            return ((Status)status).getPromotionBuilds();
        }

        public String getName(Object status) {
            return ((Status)status).getName();
        }

        public String getIcon(Object status, String size) {
            return ((Status)status).getIcon(size);
        }

        public long getStartTime(Object status) {
            return ((PromotionStatus)status).getStartTime();
        }

        public long getDuration(Object status) {
            return ((PromotionStatus)status).getDuration();
        }
    }

    static class PromotedBuildActionWrapper {
        PromotedBuildActionWrapper() {
        }

        public List<Status> getPromotions(Object action) {
            return ((PromotedBuildAction)action).getPromotions();
        }
    }
}

