/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.results;

import hudson.model.AbstractBuild;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.results.Result;

public class TestResult
extends Result {
    private int failed;
    private int skipped;
    private int total;

    public TestResult(String name, String url, int failed, int skipped, int total) {
        super(name, url);
        this.failed = failed;
        this.skipped = skipped;
        this.total = total;
    }

    @Exported
    public int getFailed() {
        return this.failed;
    }

    @Exported
    public int getSkipped() {
        return this.skipped;
    }

    @Exported
    public int getTotal() {
        return this.total;
    }

    public static List<TestResult> getResults(AbstractBuild<?, ?> build) {
        if (build != null) {
            ArrayList<TestResult> result = new ArrayList<TestResult>();
            AggregatedTestResultAction mvn = (AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class);
            if (mvn != null) {
                result.add(new TestResult(mvn.getDisplayName(), build.getUrl() + mvn.getUrlName(), mvn.getFailCount(), mvn.getSkipCount(), mvn.getTotalCount()));
            } else {
                TestResultAction freestyle = (TestResultAction)build.getAction(TestResultAction.class);
                if (freestyle != null) {
                    result.add(new TestResult(freestyle.getDisplayName(), build.getUrl() + freestyle.getUrlName(), freestyle.getFailCount(), freestyle.getSkipCount(), freestyle.getTotalCount()));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }
}

