/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.results;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.analysis.core.AbstractResultAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.MavenResultAction;
import hudson.plugins.analysis.core.ResultAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.results.Result;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;

public class StaticAnalysisResult
extends Result {
    private static final String ANALYSIS_CORE_PLUGIN = "analysis-core";
    private int high;
    private int normal;
    private int low;

    public StaticAnalysisResult(String name, String url, int high, int normal, int low) {
        super(name, url);
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    @Override
    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public int getHigh() {
        return this.high;
    }

    @Exported
    public int getNormal() {
        return this.normal;
    }

    @Exported
    public int getLow() {
        return this.low;
    }

    @Override
    @Exported
    public String getUrl() {
        return this.url;
    }

    public static List<StaticAnalysisResult> getResults(AbstractBuild<?, ?> build) {
        if (build != null && JenkinsUtil.isPluginInstalled(ANALYSIS_CORE_PLUGIN)) {
            ArrayList<StaticAnalysisResult> result = new ArrayList<StaticAnalysisResult>();
            for (Action action : build.getActions()) {
                if (!AbstractResultAction.class.isInstance(action) && !MavenResultAction.class.isInstance(action)) continue;
                BuildResult r = ((ResultAction)action).getResult();
                result.add(new StaticAnalysisResult(action.getDisplayName(), build.getUrl() + action.getUrlName(), r.getNumberOfHighPriorityWarnings(), r.getNumberOfNormalPriorityWarnings(), r.getNumberOfLowPriorityWarnings()));
            }
            return result;
        }
        return Collections.emptyList();
    }
}

