/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.CauseResolver;

@ExportedBean(defaultVisibility=100)
public class TriggerCause {
    private String type;
    private String description;
    public static final String TYPE_UPSTREAM = "UPSTREAM";
    public static final String TYPE_MANUAL = "MANUAL";
    public static final String TYPE_REMOTE = "REMOTE";
    public static final String TYPE_SCM = "SCM";
    public static final String TYPE_TIMER = "TIMER";
    public static final String TYPE_UNKNOWN = "UNKNOWN";

    public TriggerCause(String type, String description) {
        this.type = type;
        this.description = description;
    }

    @Exported
    public String getType() {
        return this.type;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public static List<TriggerCause> getTriggeredBy(AbstractProject project, AbstractBuild<?, ?> build) {
        List causes;
        HashSet<TriggerCause> result = new HashSet<TriggerCause>();
        if (build == null && project.isInQueue()) {
            causes = project.getQueueItem().getCauses();
        } else if (build != null) {
            causes = build.getCauses();
        } else {
            return new ArrayList<TriggerCause>();
        }
        for (Cause cause : causes) {
            result.add(CauseResolver.getTrigger(cause));
        }
        return new ArrayList<TriggerCause>(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerCause trigger = (TriggerCause)o;
        return this.description.equals(trigger.description) && this.type.equals(trigger.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.description.hashCode();
        return result;
    }
}

