/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Change;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.domain.Route;
import se.diabol.jenkins.pipeline.domain.Stage;
import se.diabol.jenkins.pipeline.domain.TriggerCause;
import se.diabol.jenkins.pipeline.domain.UserInfo;
import se.diabol.jenkins.pipeline.domain.task.Task;
import se.diabol.jenkins.pipeline.util.PipelineUtils;

@ExportedBean(defaultVisibility=100)
public class Pipeline
extends AbstractItem {
    private AbstractProject firstProject;
    private AbstractProject lastProject;
    private List<Stage> stages;
    private String version;
    private List<TriggerCause> triggeredBy;
    private Set<UserInfo> contributors;
    private boolean aggregated;
    private String timestamp;
    private List<Change> changes;
    private long totalBuildTime;
    private Map<String, Task> allTasks = null;

    public Pipeline(String name, AbstractProject firstProject, AbstractProject lastProject, List<Stage> stages) {
        super(name);
        this.firstProject = firstProject;
        this.lastProject = lastProject;
        this.stages = stages;
    }

    public Pipeline(String name, AbstractProject firstProject, AbstractProject lastProject, String version, String timestamp, List<TriggerCause> triggeredBy, Set<UserInfo> contributors, List<Stage> stages, boolean aggregated) {
        super(name);
        this.firstProject = firstProject;
        this.lastProject = lastProject;
        this.version = version;
        this.triggeredBy = triggeredBy;
        this.contributors = contributors;
        this.aggregated = aggregated;
        this.stages = ImmutableList.copyOf(stages);
        this.timestamp = timestamp;
    }

    @Exported
    public List<Stage> getStages() {
        return this.stages;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported
    public boolean isAggregated() {
        return this.aggregated;
    }

    @Exported
    public Set<UserInfo> getContributors() {
        return this.contributors;
    }

    @Exported
    public int getId() {
        return this.hashCode();
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    @Exported
    public List<Change> getChanges() {
        return this.changes;
    }

    @Exported
    public long getTotalBuildTime() {
        return this.totalBuildTime;
    }

    public void calculateTotalBuildTime() {
        if (this.stages.size() == 0) {
            this.totalBuildTime = 0L;
        } else {
            ArrayList<Route> allRoutes = new ArrayList<Route>();
            this.calculatePipelineRoutes(this.getStages().get(0).getTasks().get(0), null, allRoutes);
            long maxTime = 0L;
            for (Route route : allRoutes) {
                long buildTime = route.getTotalBuildTime();
                if (buildTime <= maxTime) continue;
                maxTime = buildTime;
            }
            this.totalBuildTime = maxTime;
        }
    }

    private Route createRouteAndCopyTasks(Route route, Task task) {
        Route currentRoute = new Route();
        if (route != null) {
            currentRoute.setTasks(Lists.newArrayList(route.getTasks()));
        }
        currentRoute.addTask(task);
        return currentRoute;
    }

    void calculatePipelineRoutes(Task task, Route route, List<Route> allRoutes) {
        if (task.getDownstreamTasks() != null && task.getDownstreamTasks().size() > 0) {
            for (String downstreamTaskName : task.getDownstreamTasks()) {
                Route currentRoute = this.createRouteAndCopyTasks(route, task);
                this.calculatePipelineRoutes(this.getTaskFromName(downstreamTaskName), currentRoute, allRoutes);
            }
        } else {
            Route currentRoute = this.createRouteAndCopyTasks(route, task);
            allRoutes.add(currentRoute);
        }
    }

    private Task getTaskFromName(String taskName) {
        if (this.allTasks == null) {
            this.allTasks = new HashMap<String, Task>();
            for (Stage stage : this.stages) {
                for (Task task : stage.getTasks()) {
                    this.allTasks.put(task.getId(), task);
                }
            }
        }
        return this.allTasks.get(taskName);
    }

    public static Pipeline extractPipeline(String name, AbstractProject<?, ?> firstProject, AbstractProject<?, ?> lastProject) throws PipelineException {
        return new Pipeline(name, firstProject, lastProject, Lists.newArrayList(Stage.extractStages(firstProject, lastProject)));
    }

    public static Pipeline extractPipeline(String name, AbstractProject<?, ?> firstProject) throws PipelineException {
        return new Pipeline(name, firstProject, null, Lists.newArrayList(Stage.extractStages(firstProject, null)));
    }

    public Pipeline createPipelineAggregated(ItemGroup context) {
        ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
        for (Stage stage : this.getStages()) {
            pipelineStages.add(stage.createAggregatedStage(context, this.firstProject));
        }
        return new Pipeline(this.getName(), this.firstProject, this.lastProject, null, null, null, null, pipelineStages, true);
    }

    public List<Pipeline> createPipelineLatest(int noOfPipelines, ItemGroup context) {
        ArrayList<Pipeline> result = new ArrayList<Pipeline>();
        int no = noOfPipelines;
        if (this.firstProject.isInQueue()) {
            String pipeLineTimestamp = PipelineUtils.formatTimestamp(this.firstProject.getQueueItem().getInQueueSince());
            ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
            for (Stage stage : this.getStages()) {
                pipelineStages.add(stage.createLatestStage(context, null));
            }
            Pipeline pipelineLatest = new Pipeline(this.getName(), this.firstProject, this.lastProject, "#" + this.firstProject.getNextBuildNumber(), pipeLineTimestamp, TriggerCause.getTriggeredBy(this.firstProject, null), null, pipelineStages, false);
            result.add(pipelineLatest);
            --no;
        }
        Iterator it = this.firstProject.getBuilds().iterator();
        for (int i = 0; i < no && it.hasNext(); ++i) {
            AbstractBuild firstBuild = (AbstractBuild)it.next();
            List<Change> pipelineChanges = Change.getChanges(firstBuild);
            String pipeLineTimestamp = PipelineUtils.formatTimestamp(firstBuild.getTimeInMillis());
            ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
            for (Stage stage : this.getStages()) {
                pipelineStages.add(stage.createLatestStage(context, firstBuild));
            }
            Pipeline pipelineLatest = new Pipeline(this.getName(), this.firstProject, this.lastProject, firstBuild.getDisplayName(), pipeLineTimestamp, TriggerCause.getTriggeredBy(this.firstProject, firstBuild), UserInfo.getContributors(firstBuild), pipelineStages, false);
            pipelineLatest.setChanges(pipelineChanges);
            pipelineLatest.calculateTotalBuildTime();
            result.add(pipelineLatest);
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.getId()).add("name", (Object)this.getName()).add("version", (Object)this.getVersion()).add("stages", this.getStages()).toString();
    }

    @Exported
    public List<TriggerCause> getTriggeredBy() {
        return this.triggeredBy;
    }
}

