/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import hudson.model.Api;
import java.io.IOException;
import javax.servlet.ServletException;
import org.acegisecurity.AuthenticationException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import se.diabol.jenkins.pipeline.DeliveryPipelineView;
import se.diabol.jenkins.pipeline.trigger.TriggerException;

public class PipelineApi
extends Api {
    private DeliveryPipelineView view;

    public PipelineApi(DeliveryPipelineView view) {
        super((Object)view);
        this.view = view;
    }

    public void doManualStep(StaplerRequest req, StaplerResponse rsp, @QueryParameter String project, @QueryParameter String upstream, @QueryParameter String buildId) throws IOException, ServletException {
        if (project != null && upstream != null && buildId != null) {
            try {
                this.view.triggerManual(project, upstream, buildId);
                rsp.setStatus(200);
            }
            catch (TriggerException e) {
                rsp.setStatus(500);
            }
            catch (AuthenticationException e) {
                rsp.setStatus(403);
            }
        } else {
            rsp.setStatus(406);
        }
    }

    public void doRebuildStep(StaplerRequest req, StaplerResponse rsp, @QueryParameter String project, @QueryParameter String buildId) throws IOException, ServletException {
        if (project != null && buildId != null) {
            try {
                this.view.triggerRebuild(project, buildId);
                rsp.setStatus(200);
            }
            catch (AuthenticationException e) {
                rsp.setStatus(403);
            }
        } else {
            rsp.setStatus(406);
        }
    }
}

