/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension(optional=true)
public class EnvVersionTokenMacro
extends DataBoundTokenMacro {
    private static final String NAME = "ENV_VERSION";
    public static final Class<DataBoundTokenMacro> clazz = DataBoundTokenMacro.class;
    @DataBoundTokenMacro.Parameter(required=false)
    public boolean stripSnapshot = false;

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        EnvVars env = context.getEnvironment(listener);
        if (env.containsKey(NAME)) {
            if (this.stripSnapshot) {
                String version = (String)env.get(NAME);
                return version.replace("-SNAPSHOT", "");
            }
            return (String)env.get(NAME);
        }
        return "";
    }

    public boolean acceptsMacroName(String macroName) {
        return NAME.equals(macroName);
    }
}

