/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.sort;

import hudson.Extension;
import se.diabol.jenkins.pipeline.domain.Component;
import se.diabol.jenkins.pipeline.domain.Pipeline;
import se.diabol.jenkins.pipeline.domain.Stage;
import se.diabol.jenkins.pipeline.domain.Task;
import se.diabol.jenkins.pipeline.sort.ComponentComparator;
import se.diabol.jenkins.pipeline.sort.ComponentComparatorDescriptor;

public class LatestActivityComparator
extends ComponentComparator {
    @Override
    public int compare(Component o1, Component o2) {
        return Long.valueOf(this.getLastActivity(o2)).compareTo(this.getLastActivity(o1));
    }

    private long getLastActivity(Pipeline pipeline) {
        long result = 0L;
        for (Stage stage : pipeline.getStages()) {
            for (Task task : stage.getTasks()) {
                if (task.getStatus().getLastActivity() <= result) continue;
                result = task.getStatus().getLastActivity();
            }
        }
        return result;
    }

    private long getLastActivity(Component component) {
        long result = 0L;
        for (Pipeline pipeline : component.getPipelines()) {
            long lastActivity = this.getLastActivity(pipeline);
            if (lastActivity <= result) continue;
            result = lastActivity;
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends ComponentComparatorDescriptor {
        public String getDisplayName() {
            return "Sorting by last activity";
        }

        @Override
        public ComponentComparator createInstance() {
            return new LatestActivityComparator();
        }
    }
}

