/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.AbstractItem;

public class UserInfo
extends AbstractItem {
    private final String url;

    public UserInfo(String name, String url) {
        super(name);
        this.url = url;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    public static UserInfo getUser(User user) {
        return new UserInfo(user.getDisplayName(), user.getUrl());
    }

    public static Set<UserInfo> getContributors(AbstractBuild<?, ?> build) {
        HashSet<UserInfo> contributors = new HashSet<UserInfo>();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            contributors.add(UserInfo.getUser(entry.getAuthor()));
        }
        return contributors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        return userInfo.getName().equals(userInfo.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

