/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import com.google.common.base.Strings;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.PipelineProperty;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.ManualStep;
import se.diabol.jenkins.pipeline.domain.TestResult;
import se.diabol.jenkins.pipeline.domain.status.SimpleStatus;
import se.diabol.jenkins.pipeline.domain.status.Status;
import se.diabol.jenkins.pipeline.domain.status.StatusFactory;
import se.diabol.jenkins.pipeline.util.BuildUtil;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class Task
extends AbstractItem {
    private final String id;
    private final String link;
    private final TestResult testResult;
    private final Status status;
    private final ManualStep manual;
    private final String buildId;
    private final List<String> downstreamTasks;
    private final boolean initial;

    public Task(String id, String name, Status status, String link, ManualStep manual, List<String> downstreamTasks, boolean initial) {
        super(name);
        this.id = id;
        this.link = link;
        this.testResult = null;
        this.status = status;
        this.manual = manual;
        this.buildId = null;
        this.downstreamTasks = downstreamTasks;
        this.initial = initial;
    }

    public Task(Task task, String buildId, Status status, String link, ManualStep manual, TestResult testResult) {
        super(task.getName());
        this.id = task.id;
        this.downstreamTasks = task.getDownstreamTasks();
        this.buildId = buildId;
        this.status = status;
        this.link = link;
        this.manual = manual;
        this.testResult = testResult;
        this.initial = task.isInitial();
    }

    @Exported
    public ManualStep getManualStep() {
        return this.manual;
    }

    @Exported
    public boolean isManual() {
        return this.manual != null;
    }

    @Exported
    public String getBuildId() {
        return this.buildId;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public String getLink() {
        return this.link;
    }

    @Exported
    public TestResult getTestResult() {
        return this.testResult;
    }

    @Exported
    public Status getStatus() {
        return this.status;
    }

    @Exported
    public List<String> getDownstreamTasks() {
        return this.downstreamTasks;
    }

    @Exported
    public boolean isRebuildable() {
        if (this.initial) {
            return false;
        }
        return !this.status.isRunning() && !this.status.isIdle() && !this.status.isNotBuilt() && !this.status.isQueued() && !this.status.isDisabled();
    }

    public boolean isInitial() {
        return this.initial;
    }

    public static Task getPrototypeTask(AbstractProject project, boolean initial) {
        PipelineProperty property = (PipelineProperty)project.getProperty(PipelineProperty.class);
        String taskName = property == null && project.getParent() instanceof AbstractProject ? ((property = (PipelineProperty)((AbstractProject)project.getParent()).getProperty(PipelineProperty.class)) != null && !Strings.isNullOrEmpty((String)property.getTaskName()) ? property.getTaskName() + " " + project.getName() : project.getDisplayName()) : ((property = (PipelineProperty)project.getProperty(PipelineProperty.class)) != null && !Strings.isNullOrEmpty((String)property.getTaskName()) ? property.getTaskName() : project.getDisplayName());
        Status status = project.isDisabled() ? StatusFactory.disabled() : StatusFactory.idle();
        List<AbstractProject> downStreams = ProjectUtil.getDownstreamProjects(project);
        ArrayList<String> downStreamTasks = new ArrayList<String>();
        for (AbstractProject downstreamProject : downStreams) {
            downStreamTasks.add(downstreamProject.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()));
        }
        return new Task(project.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), taskName, status, project.getUrl(), ManualStep.resolveManualStep(project), downStreamTasks, initial);
    }

    public Task getLatestTask(ItemGroup context, AbstractBuild firstBuild) {
        AbstractProject project = this.getProject(this, context);
        AbstractBuild build = null;
        if (!ProjectUtil.isQueued(project, firstBuild)) {
            build = BuildUtil.match((RunList<? extends AbstractBuild>)project.getBuilds(), firstBuild);
        }
        Status taskStatus = SimpleStatus.resolveStatus(project, build, firstBuild);
        String taskLink = build == null || taskStatus.isIdle() || taskStatus.isQueued() ? this.getLink() : (taskStatus.isRunning() ? build.getUrl() + "console" : build.getUrl());
        String taskBuildId = build == null || taskStatus.isIdle() || taskStatus.isQueued() ? null : String.valueOf(build.getNumber());
        ManualStep manualStep = ManualStep.getManualStepLatest(project, build, firstBuild);
        return new Task(this, taskBuildId, taskStatus, taskLink, manualStep, TestResult.getTestResult(build));
    }

    public Task getAggregatedTask(AbstractBuild versionBuild, ItemGroup context) {
        AbstractProject taskProject = this.getProject(this, context);
        AbstractBuild currentBuild = BuildUtil.match((RunList<? extends AbstractBuild>)taskProject.getBuilds(), versionBuild);
        if (currentBuild != null) {
            Status taskStatus = SimpleStatus.resolveStatus(taskProject, currentBuild, null);
            String taskLink = currentBuild.getUrl();
            if (taskStatus.isRunning()) {
                taskLink = currentBuild.getUrl() + "console";
            }
            return new Task(this, String.valueOf(currentBuild.getNumber()), taskStatus, taskLink, this.getManualStep(), TestResult.getTestResult(currentBuild));
        }
        return new Task(this, null, StatusFactory.idle(), this.getLink(), this.getManualStep(), null);
    }

    private AbstractProject getProject(Task task, ItemGroup context) {
        return ProjectUtil.getProject(task.getId(), context);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Task{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", link='").append(this.link).append('\'');
        sb.append(", testResult=").append(this.testResult);
        sb.append(", status=").append(this.status);
        sb.append(", manual=").append(this.manual);
        sb.append(", buildId='").append(this.buildId).append('\'');
        sb.append(", downstreamTasks=").append(this.downstreamTasks);
        sb.append('}');
        return sb.toString();
    }
}

