/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.UserInfo;

@ExportedBean(defaultVisibility=100)
public class Change {
    private UserInfo author;
    private String message;
    private String commitId;
    private String changeLink;
    private static final Logger LOG = Logger.getLogger(Change.class.getName());

    public Change(UserInfo author, String message, String commitId, String changeLink) {
        this.author = author;
        this.message = message;
        this.commitId = commitId;
        this.changeLink = changeLink;
    }

    @Exported
    public UserInfo getAuthor() {
        return this.author;
    }

    @Exported
    public String getMessage() {
        return this.message;
    }

    @Exported
    public String getCommitId() {
        return this.commitId;
    }

    @Exported
    public String getChangeLink() {
        return this.changeLink;
    }

    public static List<Change> getChanges(AbstractBuild<?, ?> build) {
        RepositoryBrowser repositoryBrowser = build.getProject().getScm().getBrowser();
        ArrayList<Change> result = new ArrayList<Change>();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            UserInfo user = UserInfo.getUser(entry.getAuthor());
            String changeLink = null;
            if (repositoryBrowser != null) {
                try {
                    URL link = repositoryBrowser.getChangeSetLink(entry);
                    if (link != null) {
                        changeLink = link.toExternalForm();
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Could not get changeset link for: " + build.getProject().getFullDisplayName() + " " + build.getDisplayName(), e);
                }
            }
            result.add(new Change(user, entry.getMsg(), entry.getCommitId(), changeLink));
        }
        return result;
    }
}

