/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.status;

import se.diabol.jenkins.pipeline.domain.status.Running;
import se.diabol.jenkins.pipeline.domain.status.SimpleStatus;
import se.diabol.jenkins.pipeline.domain.status.Status;
import se.diabol.jenkins.pipeline.domain.status.StatusType;

public final class StatusFactory {
    private StatusFactory() {
    }

    public static Status idle() {
        return new SimpleStatus(StatusType.IDLE, -1L, -1L);
    }

    public static Status running(int percentage, long lastActivity, long duration) {
        return new Running(percentage, lastActivity, duration);
    }

    public static Status queued(long lastActivity) {
        return new SimpleStatus(StatusType.QUEUED, lastActivity, -1L);
    }

    public static Status success(long lastActivity, long duration) {
        return new SimpleStatus(StatusType.SUCCESS, lastActivity, duration);
    }

    public static Status failed(long lastActivity, long duration) {
        return new SimpleStatus(StatusType.FAILED, lastActivity, duration);
    }

    public static Status unstable(long lastActivity, long duration) {
        return new SimpleStatus(StatusType.UNSTABLE, lastActivity, duration);
    }

    public static Status cancelled(long lastActivity, long duration) {
        return new SimpleStatus(StatusType.CANCELLED, lastActivity, duration);
    }

    public static Status disabled() {
        return new SimpleStatus(StatusType.DISABLED, -1L, -1L);
    }
}

