/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.status;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.status.Status;
import se.diabol.jenkins.pipeline.domain.status.StatusFactory;
import se.diabol.jenkins.pipeline.domain.status.StatusType;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class SimpleStatus
implements Status {
    private final StatusType type;
    private final long lastActivity;
    private final long duration;

    public SimpleStatus(StatusType type, long lastActivity, long duration) {
        this.type = type;
        this.lastActivity = lastActivity;
        this.duration = duration;
    }

    @Override
    @Exported
    public StatusType getType() {
        return this.type;
    }

    @Override
    public long getLastActivity() {
        return this.lastActivity;
    }

    @Override
    @Exported
    public String getTimestamp() {
        if (this.lastActivity != -1L) {
            return PipelineUtils.formatTimestamp(this.lastActivity);
        }
        return null;
    }

    @Override
    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isIdle() {
        return StatusType.IDLE.equals((Object)this.type);
    }

    @Override
    public boolean isQueued() {
        return StatusType.QUEUED.equals((Object)this.type);
    }

    @Override
    public boolean isRunning() {
        return StatusType.RUNNING.equals((Object)this.type);
    }

    @Override
    public boolean isSuccess() {
        return StatusType.SUCCESS.equals((Object)this.type);
    }

    @Override
    public boolean isFailed() {
        return StatusType.FAILED.equals((Object)this.type);
    }

    @Override
    public boolean isUnstable() {
        return StatusType.UNSTABLE.equals((Object)this.type);
    }

    @Override
    public boolean isCancelled() {
        return StatusType.CANCELLED.equals((Object)this.type);
    }

    @Override
    public boolean isDisabled() {
        return StatusType.DISABLED.equals((Object)this.type);
    }

    public static Status resolveStatus(AbstractProject project, AbstractBuild build, AbstractBuild firstBuild) {
        if (build == null) {
            if (ProjectUtil.isQueued(project, firstBuild)) {
                return StatusFactory.queued(project.getQueueItem().getInQueueSince());
            }
            if (project.isDisabled()) {
                return StatusFactory.disabled();
            }
            return StatusFactory.idle();
        }
        if (build.isBuilding()) {
            int progress = (int)Math.round(100.0 * (double)(System.currentTimeMillis() - build.getTimestamp().getTimeInMillis()) / (double)build.getEstimatedDuration());
            if (progress > 100) {
                progress = 99;
            }
            return StatusFactory.running(progress, build.getTimeInMillis(), System.currentTimeMillis() - build.getTimestamp().getTimeInMillis());
        }
        Result result = build.getResult();
        if (Result.ABORTED.equals(result)) {
            return StatusFactory.cancelled(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.SUCCESS.equals(result)) {
            return StatusFactory.success(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.FAILURE.equals(result)) {
            return StatusFactory.failed(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.UNSTABLE.equals(result)) {
            return StatusFactory.unstable(build.getTimeInMillis(), build.getDuration());
        }
        throw new IllegalStateException("Result " + result + " not recognized.");
    }

    public String toString() {
        return String.valueOf((Object)this.type);
    }
}

