/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.ExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.tasks.UserAvatarResolver;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.AbstractItem;

public class UserInfo
extends AbstractItem {
    private static final int AVATAR_SIZE = 16;
    private final String avatarUrl;
    private final String url;

    public UserInfo(String name, String url, String avatarUrl) {
        super(name);
        this.avatarUrl = avatarUrl;
        this.url = url;
    }

    @Exported
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    public static UserInfo getUser(User user) {
        return new UserInfo(user.getDisplayName(), user.getUrl(), UserInfo.getAvatarUrl(user));
    }

    private static String getAvatarUrl(User user) {
        ExtensionList resolvers = UserAvatarResolver.all();
        for (UserAvatarResolver resolver : resolvers) {
            String avatarUrl = resolver.findAvatarFor(user, 16, 16);
            if (avatarUrl == null) continue;
            return avatarUrl;
        }
        return null;
    }

    public static Set<UserInfo> getContributors(AbstractBuild<?, ?> build) {
        HashSet<UserInfo> contributors = new HashSet<UserInfo>();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            contributors.add(UserInfo.getUser(entry.getAuthor()));
        }
        return contributors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        return userInfo.getName().equals(userInfo.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

