/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=100)
public class Trigger {
    private String type;
    private String description;
    public static final String TYPE_UPSTREAM = "UPSTREAM";
    public static final String TYPE_MANUAL = "MANUAL";
    public static final String TYPE_REMOTE = "REMOTE";
    public static final String TYPE_SCM = "SCM";
    public static final String TYPE_TIMER = "TIMER";
    public static final String TYPE_UNKNOWN = "UNKNOWN";

    public Trigger(String type, String description) {
        this.type = type;
        this.description = description;
    }

    @Exported
    public String getType() {
        return this.type;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public static List<Trigger> getTriggeredBy(AbstractBuild<?, ?> build) {
        HashSet<Trigger> result = new HashSet<Trigger>();
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (cause instanceof Cause.UserIdCause) {
                result.add(new Trigger(TYPE_MANUAL, "user " + Trigger.getDisplayName(((Cause.UserIdCause)cause).getUserName())));
                continue;
            }
            if (cause instanceof Cause.RemoteCause) {
                result.add(new Trigger(TYPE_REMOTE, "remote trigger"));
                continue;
            }
            if (cause instanceof Cause.UpstreamCause) {
                Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
                AbstractProject upstreamProject = (AbstractProject)Jenkins.getInstance().getItem(upstreamCause.getUpstreamProject(), (ItemGroup)Jenkins.getInstance(), AbstractProject.class);
                StringBuilder causeString = new StringBuilder("upstream project");
                if (upstreamProject != null) {
                    causeString.append(" ").append(upstreamProject.getDisplayName());
                    AbstractBuild upstreamBuild = upstreamProject.getBuildByNumber(upstreamCause.getUpstreamBuild());
                    if (upstreamBuild != null) {
                        causeString.append(" build ").append(upstreamBuild.getDisplayName());
                    }
                }
                result.add(new Trigger(TYPE_UPSTREAM, causeString.toString()));
                continue;
            }
            if (cause instanceof Cause.UpstreamCause.DeeplyNestedUpstreamCause) {
                result.add(new Trigger(TYPE_UPSTREAM, "upstream"));
                continue;
            }
            if (cause instanceof SCMTrigger.SCMTriggerCause) {
                result.add(new Trigger(TYPE_SCM, TYPE_SCM));
                continue;
            }
            if (cause instanceof TimerTrigger.TimerTriggerCause) {
                result.add(new Trigger(TYPE_TIMER, "timer"));
                continue;
            }
            result.add(new Trigger(TYPE_UNKNOWN, "unknown cause"));
        }
        return new ArrayList<Trigger>(result);
    }

    private static String getDisplayName(String userName) {
        User user = Jenkins.getInstance().getUser(userName);
        if (user != null) {
            return user.getDisplayName();
        }
        return "anonymous";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        return this.description.equals(trigger.description) && this.type.equals(trigger.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.description.hashCode();
        return result;
    }
}

