/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.tasks.test.AggregatedTestResultAction;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=100)
public class TestResult {
    private int failed;
    private int skipped;
    private int total;
    private String url;

    public TestResult(int failed, int skipped, int total, String url) {
        this.failed = failed;
        this.skipped = skipped;
        this.total = total;
        this.url = url;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    @Exported
    public int getFailed() {
        return this.failed;
    }

    @Exported
    public int getSkipped() {
        return this.skipped;
    }

    @Exported
    public int getTotal() {
        return this.total;
    }

    public static TestResult getTestResult(AbstractBuild build) {
        AggregatedTestResultAction tests;
        if (build != null && (tests = (AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class)) != null) {
            return new TestResult(tests.getFailCount(), tests.getSkipCount(), tests.getTotalCount(), build.getUrl() + tests.getUrlName());
        }
        return null;
    }
}

