/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Change;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.domain.Stage;
import se.diabol.jenkins.pipeline.domain.Trigger;
import se.diabol.jenkins.pipeline.domain.UserInfo;
import se.diabol.jenkins.pipeline.util.PipelineUtils;

@ExportedBean(defaultVisibility=100)
public class Pipeline
extends AbstractItem {
    private AbstractProject firstProject;
    private List<Stage> stages;
    private String version;
    private List<Trigger> triggeredBy;
    private Set<UserInfo> contributors;
    private boolean aggregated;
    private String timestamp;
    private List<Change> changes;

    public Pipeline(String name, AbstractProject firstProject, List<Stage> stages) {
        super(name);
        this.firstProject = firstProject;
        this.stages = stages;
    }

    public Pipeline(String name, AbstractProject firstProject, String version, String timestamp, List<Trigger> triggeredBy, Set<UserInfo> contributors, List<Stage> stages, boolean aggregated) {
        super(name);
        this.firstProject = firstProject;
        this.version = version;
        this.triggeredBy = triggeredBy;
        this.contributors = contributors;
        this.aggregated = aggregated;
        this.stages = ImmutableList.copyOf(stages);
        this.timestamp = timestamp;
    }

    @Exported
    public List<Stage> getStages() {
        return this.stages;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported
    public boolean isAggregated() {
        return this.aggregated;
    }

    @Exported
    public Set<UserInfo> getContributors() {
        return this.contributors;
    }

    @Exported
    public int getId() {
        return this.hashCode();
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    @Exported
    public List<Change> getChanges() {
        return this.changes;
    }

    public static Pipeline extractPipeline(String name, AbstractProject<?, ?> firstProject) throws PipelineException {
        return new Pipeline(name, firstProject, Lists.newArrayList(Stage.extractStages(firstProject)));
    }

    public Pipeline createPipelineAggregated(ItemGroup context) {
        ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
        for (Stage stage : this.getStages()) {
            pipelineStages.add(stage.createAggregatedStage(context, this.firstProject));
        }
        return new Pipeline(this.getName(), this.firstProject, null, null, null, null, pipelineStages, true);
    }

    public List<Pipeline> createPipelineLatest(int noOfPipelines, ItemGroup context) {
        ArrayList<Pipeline> result = new ArrayList<Pipeline>();
        Iterator it = this.firstProject.getBuilds().iterator();
        for (int i = 0; i < noOfPipelines && it.hasNext(); ++i) {
            AbstractBuild firstBuild = (AbstractBuild)it.next();
            List<Change> pipelineChanges = Change.getChanges(firstBuild);
            String pipeLineTimestamp = PipelineUtils.formatTimestamp(firstBuild.getTimeInMillis());
            ArrayList<Stage> pipelineStages = new ArrayList<Stage>();
            for (Stage stage : this.getStages()) {
                pipelineStages.add(stage.createLatestStage(context, firstBuild));
            }
            Pipeline pipelineLatest = new Pipeline(this.getName(), this.firstProject, firstBuild.getDisplayName(), pipeLineTimestamp, Trigger.getTriggeredBy(firstBuild), UserInfo.getContributors(firstBuild), pipelineStages, false);
            pipelineLatest.setChanges(pipelineChanges);
            result.add(pipelineLatest);
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.getId()).add("name", (Object)this.getName()).add("version", (Object)this.getVersion()).add("stages", this.getStages()).toString();
    }

    @Exported
    public List<Trigger> getTriggeredBy() {
        return this.triggeredBy;
    }
}

