/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.util.RunList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.trigger.ManualTriggerResolver;
import se.diabol.jenkins.pipeline.util.BuildUtil;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class ManualStep {
    private String upstreamProject;
    private String upstreamId;
    private boolean enabled;
    private boolean permission;
    private Map<String, String> possibleVersions;

    public ManualStep(String upstreamProject, String upstreamId, boolean enabled, boolean permission, Map<String, String> possibleVersions) {
        this.upstreamProject = upstreamProject;
        this.upstreamId = upstreamId;
        this.enabled = enabled;
        this.permission = permission;
        this.possibleVersions = possibleVersions;
    }

    public static ManualStep resolveManualStep(AbstractProject project) {
        if (ManualStep.isManualTrigger(project)) {
            return new ManualStep(project.getName(), null, false, project.hasPermission(Item.BUILD), null);
        }
        return null;
    }

    protected static boolean isManualTrigger(AbstractProject<?, ?> project) {
        List<ManualTriggerResolver> resolvers = ManualTriggerResolver.all();
        for (ManualTriggerResolver manualTriggerResolver : resolvers) {
            if (!manualTriggerResolver.isManualTrigger(project)) continue;
            return true;
        }
        return false;
    }

    public static ManualStep getManualStepLatest(AbstractProject project, AbstractBuild build, AbstractBuild firstBuild) {
        if (ManualStep.isManualTrigger(project)) {
            AbstractProject upstream = (AbstractProject)project.getUpstreamProjects().get(0);
            AbstractBuild upstreamBuild = BuildUtil.match((RunList<? extends AbstractBuild>)upstream.getBuilds(), firstBuild);
            if (build == null) {
                if (upstreamBuild != null && !upstreamBuild.isBuilding() && !ProjectUtil.isQueued(project, firstBuild)) {
                    return new ManualStep(upstream.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), String.valueOf(upstreamBuild.getNumber()), true, project.hasPermission(Item.BUILD), null);
                }
                return new ManualStep(upstream.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), null, false, project.hasPermission(Item.BUILD), null);
            }
            if (!build.isBuilding() && !ProjectUtil.isQueued(project, firstBuild) && build.getResult().isWorseThan(Result.UNSTABLE)) {
                return new ManualStep(upstream.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), String.valueOf(upstreamBuild.getNumber()), true, project.hasPermission(Item.BUILD), null);
            }
        }
        return null;
    }

    public static ManualStep getManualStepAggregated(AbstractProject project, AbstractProject firstProject) {
        if (ManualStep.isManualTrigger(project)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            AbstractProject upstream = (AbstractProject)project.getUpstreamProjects().get(0);
            for (AbstractBuild build : upstream.getBuilds()) {
                AbstractBuild versionBuild = BuildUtil.getFirstUpstreamBuild(build, firstProject);
                if (versionBuild == null || versions.containsKey(versionBuild.getDisplayName())) continue;
                versions.put(versionBuild.getDisplayName(), String.valueOf(versionBuild.getNumber()));
            }
            if (versions.size() == 0) {
                return new ManualStep(upstream.getName(), null, false, project.hasPermission(Item.BUILD), versions);
            }
            return new ManualStep(upstream.getName(), null, true, project.hasPermission(Item.BUILD), versions);
        }
        return null;
    }

    @Exported
    public String getUpstreamProject() {
        return this.upstreamProject;
    }

    @Exported
    public String getUpstreamId() {
        return this.upstreamId;
    }

    @Exported
    public boolean isEnabled() {
        return this.enabled;
    }

    @Exported
    public boolean isPermission() {
        return this.permission;
    }

    @Exported
    public Map<String, String> getPossibleVersions() {
        return this.possibleVersions;
    }
}

