/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.util;

import com.google.common.collect.Lists;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import se.diabol.jenkins.pipeline.model.Edge;
import se.diabol.jenkins.pipeline.model.Stage;
import se.diabol.jenkins.pipeline.model.Task;

public final class StageUtil {
    private StageUtil() {
    }

    public static List<Stage> placeStages(AbstractProject firstProject, Collection<Stage> stages) {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(Edge.class);
        for (Stage stage : stages) {
            stage.setTaskConnections(StageUtil.getStageConnections(stage, stages));
            graph.addVertex((Object)stage);
            List<Stage> downstreamStages = StageUtil.getDownstreamStages(stage, stages);
            ArrayList<String> downstreamStageNames = new ArrayList<String>();
            for (Stage downstream : downstreamStages) {
                downstreamStageNames.add(downstream.getName());
                graph.addVertex((Object)downstream);
                graph.addEdge((Object)stage, (Object)downstream, (Object)new Edge(stage, downstream));
            }
            stage.setDownstreamStages(downstreamStageNames);
        }
        List<List<Stage>> allPaths = StageUtil.findAllRunnablePaths(StageUtil.findStageForJob(firstProject.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), stages), (DirectedGraph<Stage, Edge>)graph);
        Collections.sort(allPaths, new Comparator<List<Stage>>(){

            @Override
            public int compare(List<Stage> stages1, List<Stage> stages2) {
                return stages2.size() - stages1.size();
            }
        });
        for (int row = allPaths.size() - 1; row >= 0; --row) {
            List<Stage> path = allPaths.get(row);
            for (int column = 0; column < path.size(); ++column) {
                Stage stage = path.get(column);
                stage.setColumn(Math.max(stage.getColumn(), column));
                stage.setRow(row);
            }
        }
        return new ArrayList<Stage>(stages);
    }

    private static Map<String, List<String>> getStageConnections(Stage stage, Collection<Stage> stages) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (int i = 0; i < stage.getTasks().size(); ++i) {
            Task task = stage.getTasks().get(i);
            for (int j = 0; j < task.getDownstreamTasks().size(); ++j) {
                String downstreamTask = task.getDownstreamTasks().get(j);
                Stage target = StageUtil.findStageForJob(downstreamTask, stages);
                if (stage.equals(target)) continue;
                if (result.get(task.getId()) == null) {
                    result.put(task.getId(), new ArrayList<String>(Collections.singleton(downstreamTask)));
                    continue;
                }
                ((List)result.get(task.getId())).add(downstreamTask);
            }
        }
        return result;
    }

    private static List<List<Stage>> findAllRunnablePaths(Stage start, DirectedGraph<Stage, Edge> graph) {
        LinkedList<List<Stage>> paths = new LinkedList<List<Stage>>();
        if (graph.outDegreeOf((Object)start) == 0) {
            LinkedList<Stage> path = new LinkedList<Stage>();
            path.add(start);
            paths.add(path);
        } else {
            for (Edge edge : graph.outgoingEdgesOf((Object)start)) {
                List<List<Stage>> allPathsFromTarget = StageUtil.findAllRunnablePaths(edge.getTarget(), graph);
                for (List<Stage> path : allPathsFromTarget) {
                    path.add(0, start);
                }
                paths.addAll(allPathsFromTarget);
            }
        }
        return paths;
    }

    private static List<Stage> getDownstreamStages(Stage stage, Collection<Stage> stages) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < stage.getTasks().size(); ++i) {
            Task task = stage.getTasks().get(i);
            for (int j = 0; j < task.getDownstreamTasks().size(); ++j) {
                String jobName = task.getDownstreamTasks().get(j);
                Stage target = StageUtil.findStageForJob(jobName, stages);
                if (target == null || target.getName().equals(stage.getName())) continue;
                result.add(target);
            }
        }
        return result;
    }

    private static Stage findStageForJob(String name, Collection<Stage> stages) {
        for (Stage stage : stages) {
            for (int j = 0; j < stage.getTasks().size(); ++j) {
                Task task = stage.getTasks().get(j);
                if (!task.getId().equals(name)) continue;
                return stage;
            }
        }
        return null;
    }
}

