/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.util;

import com.google.common.collect.Maps;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.SubProjectsAction;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;

public final class ProjectUtil {
    private static final Logger LOG = Logger.getLogger(ProjectUtil.class.getName());

    private ProjectUtil() {
    }

    public static ListBoxModel fillAllProjects(ItemGroup<?> context) {
        ListBoxModel options = new ListBoxModel();
        for (AbstractProject p : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
            options.add(p.getFullDisplayName(), p.getRelativeNameFrom(context));
        }
        return options;
    }

    public static Map<String, AbstractProject<?, ?>> getAllDownstreamProjects(AbstractProject first) {
        LinkedHashMap projects = Maps.newLinkedHashMap();
        projects.put(first.getName(), first);
        for (AbstractProject project : ProjectUtil.getDownstreamProjects(first)) {
            projects.putAll(ProjectUtil.getAllDownstreamProjects(project));
        }
        return projects;
    }

    public static List<AbstractProject> getDownstreamProjects(AbstractProject<?, ?> project) {
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        result.addAll(ProjectUtil.getSubProjects(project));
        result.addAll(project.getDownstreamProjects());
        return result;
    }

    protected static List<AbstractProject> getSubProjects(AbstractProject project) {
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        for (SubProjectsAction action : Util.filter((List)project.getActions(), SubProjectsAction.class)) {
            for (BlockableBuildTriggerConfig config : action.getConfigs()) {
                for (AbstractProject subProject : config.getProjectList(project.getParent(), null)) {
                    result.add(subProject);
                }
            }
        }
        return result;
    }

    public static AbstractProject<?, ?> getProject(String name, ItemGroup context) {
        return (AbstractProject)Jenkins.getInstance().getItem(name, context, AbstractProject.class);
    }

    public static AbstractProject getProject(String name) {
        Map items = Jenkins.getInstance().getItemMap();
        if (items.containsKey(name)) {
            return (AbstractProject)items.get(name);
        }
        List groups = Util.createSubList(items.values(), ItemGroup.class);
        for (ItemGroup group : groups) {
            AbstractProject project = ProjectUtil.find(group, name);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    private static AbstractProject find(ItemGroup group, String name) {
        List projects = Util.createSubList((Collection)group.getItems(), AbstractProject.class);
        for (AbstractProject project : projects) {
            if (!project.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()).equals(name)) continue;
            return project;
        }
        List groups = Util.createSubList((Collection)group.getItems(), ItemGroup.class);
        for (ItemGroup itemGroup : groups) {
            AbstractProject project = ProjectUtil.find(itemGroup, name);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    public static Map<String, AbstractProject> getProjects(String regExp) {
        try {
            Pattern pattern = Pattern.compile(regExp);
            HashMap<String, AbstractProject> result = new HashMap<String, AbstractProject>();
            for (AbstractProject project : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                Matcher matcher = pattern.matcher(project.getName());
                if (!matcher.find()) continue;
                if (matcher.groupCount() >= 1) {
                    String name = matcher.group(1);
                    result.put(name, project);
                    continue;
                }
                LOG.log(Level.WARNING, "Could not find match group");
            }
            return result;
        }
        catch (PatternSyntaxException e) {
            LOG.log(Level.WARNING, "Could not find projects on regular expression", e);
            return Collections.emptyMap();
        }
    }
}

