/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.model.status;

import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.model.Status;
import se.diabol.jenkins.pipeline.model.status.StatusType;
import se.diabol.jenkins.pipeline.util.PipelineUtils;

@ExportedBean(defaultVisibility=100)
public class SimpleStatus
implements Status {
    private final StatusType type;
    private final long lastActivity;
    private final long duration;

    public SimpleStatus(StatusType type, long lastActivity, long duration) {
        this.type = type;
        this.lastActivity = lastActivity;
        this.duration = duration;
    }

    @Exported
    public StatusType getType() {
        return this.type;
    }

    @Override
    public long getLastActivity() {
        return this.lastActivity;
    }

    @Override
    @Exported
    public String getTimestamp() {
        if (this.lastActivity != -1L) {
            return PipelineUtils.formatTimestamp(this.lastActivity);
        }
        return null;
    }

    @Override
    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isIdle() {
        return StatusType.IDLE.equals((Object)this.type);
    }

    @Override
    public boolean isQueued() {
        return StatusType.QUEUED.equals((Object)this.type);
    }

    @Override
    public boolean isRunning() {
        return StatusType.RUNNING.equals((Object)this.type);
    }

    @Override
    public boolean isSuccess() {
        return StatusType.SUCCESS.equals((Object)this.type);
    }

    @Override
    public boolean isFailed() {
        return StatusType.FAILED.equals((Object)this.type);
    }

    @Override
    public boolean isUnstable() {
        return StatusType.UNSTABLE.equals((Object)this.type);
    }

    @Override
    public boolean isCancelled() {
        return StatusType.CANCELLED.equals((Object)this.type);
    }

    @Override
    public boolean isDisabled() {
        return StatusType.DISABLED.equals((Object)this.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimpleStatus && this.type.equals((Object)((SimpleStatus)obj).getType());
    }

    public String toString() {
        return String.valueOf((Object)this.type);
    }
}

