/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.model;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.model.AbstractItem;
import se.diabol.jenkins.pipeline.model.Status;
import se.diabol.jenkins.pipeline.model.TestResult;

@ExportedBean(defaultVisibility=100)
public class Task
extends AbstractItem {
    private final String id;
    private final String link;
    private final TestResult testResult;
    private final Status status;
    private final boolean manual;
    private final String buildId;
    private final List<String> downstreamTasks;

    public Task(String id, String name, String buildId, Status status, String link, boolean manual, TestResult testResult, List<String> downstreamTasks) {
        super(name);
        this.id = id;
        this.link = link;
        this.testResult = testResult;
        this.status = status;
        this.manual = manual;
        this.buildId = buildId;
        this.downstreamTasks = downstreamTasks;
    }

    @Exported
    public boolean isManual() {
        return this.manual;
    }

    @Exported
    public String getBuildId() {
        return this.buildId;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public String getLink() {
        return this.link;
    }

    @Exported
    public TestResult getTestResult() {
        return this.testResult;
    }

    @Exported
    public Status getStatus() {
        return this.status;
    }

    @Exported
    public List<String> getDownstreamTasks() {
        return this.downstreamTasks;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.status).appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Task && this.equalsSelf((Task)obj);
    }

    private boolean equalsSelf(Task o) {
        return new EqualsBuilder().append((Object)this.id, (Object)o.id).append((Object)this.status, (Object)o.status).appendSuper(super.equals(o)).isEquals();
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("status", (Object)this.getStatus()).toString();
    }
}

