/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.model.AbstractItem;
import se.diabol.jenkins.pipeline.model.Task;

@ExportedBean(defaultVisibility=100)
public class Stage
extends AbstractItem {
    private List<Task> tasks;
    private String version;
    private int row;
    private int column;
    private Map<String, List<String>> taskConnections;
    private List<String> downstreamStages;

    public Stage(String name, List<Task> tasks, List<String> downstreamStages, Map<String, List<String>> taskConnections) {
        super(name);
        this.tasks = ImmutableList.copyOf(tasks);
        this.downstreamStages = downstreamStages;
        this.taskConnections = taskConnections;
    }

    public Stage(String name, List<Task> tasks, List<String> downstreamStages, Map<String, List<String>> taskConnections, String version, int row, int column) {
        super(name);
        this.tasks = tasks;
        this.version = version;
        this.row = row;
        this.column = column;
        this.downstreamStages = downstreamStages;
        this.taskConnections = taskConnections;
    }

    @Exported
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Exported
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Exported
    public List<String> getDownstreamStages() {
        return this.downstreamStages;
    }

    public void setDownstreamStages(List<String> downstreamStages) {
        this.downstreamStages = downstreamStages;
    }

    @Exported
    public Map<String, List<String>> getTaskConnections() {
        return this.taskConnections;
    }

    public void setTaskConnections(Map<String, List<String>> taskConnections) {
        this.taskConnections = taskConnections;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.tasks).append((Object)this.version).appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Stage && this.equalsSelf((Stage)o);
    }

    private boolean equalsSelf(Stage o) {
        return new EqualsBuilder().append(this.tasks, o.tasks).append((Object)this.version, (Object)o.version).appendSuper(super.equals(o)).isEquals();
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("version", (Object)this.getVersion()).add("tasks", this.getTasks()).toString();
    }
}

