/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.model.AbstractItem;
import se.diabol.jenkins.pipeline.model.Change;
import se.diabol.jenkins.pipeline.model.Stage;
import se.diabol.jenkins.pipeline.model.Trigger;
import se.diabol.jenkins.pipeline.model.UserInfo;

@ExportedBean(defaultVisibility=100)
public class Pipeline
extends AbstractItem {
    private List<Stage> stages;
    private String version;
    private List<Trigger> triggeredBy;
    private Set<UserInfo> contributors;
    private boolean aggregated;
    private String timestamp;
    private List<Change> changes;

    public Pipeline(String name, String version, String timestamp, List<Trigger> triggeredBy, Set<UserInfo> contributors, List<Stage> stages, boolean aggregated) {
        super(name);
        this.version = version;
        this.triggeredBy = triggeredBy;
        this.contributors = contributors;
        this.aggregated = aggregated;
        this.stages = ImmutableList.copyOf(stages);
        this.timestamp = timestamp;
    }

    @Exported
    public List<Stage> getStages() {
        return this.stages;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported
    public boolean isAggregated() {
        return this.aggregated;
    }

    @Exported
    public Set<UserInfo> getContributors() {
        return this.contributors;
    }

    @Exported
    public int getId() {
        return this.hashCode();
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    @Exported
    public List<Change> getChanges() {
        return this.changes;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.version).append(this.stages).toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Pipeline && this.equalsSelf((Pipeline)o);
    }

    private boolean equalsSelf(Pipeline o) {
        return super.equals(o) && new EqualsBuilder().appendSuper(super.equals(o)).append(this.stages, o.stages).append((Object)this.version, (Object)o.version).isEquals();
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.getId()).add("name", (Object)this.getName()).add("version", (Object)this.getVersion()).add("stages", this.getStages()).toString();
    }

    @Exported
    public List<Trigger> getTriggeredBy() {
        return this.triggeredBy;
    }
}

