/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.model.AbstractItem;
import se.diabol.jenkins.pipeline.model.Pipeline;

@ExportedBean(defaultVisibility=100)
public class Component
extends AbstractItem {
    private final List<Pipeline> pipelines;

    public Component(String name, List<Pipeline> pipelines) {
        super(name);
        this.pipelines = ImmutableList.copyOf(pipelines);
    }

    @Exported
    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("pipelines", this.pipelines).toString();
    }

    @Override
    public int hashCode() {
        return this.pipelines.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Component && this.equalsSelf((Component)o);
    }

    private boolean equalsSelf(Component o) {
        return super.equals(o) && this.pipelines.equals(o.pipelines);
    }
}

