/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;

public class PipelineVersionContributor
extends BuildWrapper {
    public static final String VERSION_PARAMETER = "PIPELINE_VERSION";
    private String versionTemplate;
    private boolean updateDisplayName = false;
    private static final Logger LOG = Logger.getLogger(PipelineVersionContributor.class.getName());

    @DataBoundConstructor
    public PipelineVersionContributor(boolean updateDisplayName, String versionTemplate) {
        this.updateDisplayName = updateDisplayName;
        this.versionTemplate = versionTemplate;
    }

    public String getVersionTemplate() {
        return this.versionTemplate;
    }

    public boolean isUpdateDisplayName() {
        return this.updateDisplayName;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        try {
            String version = TokenMacro.expand((AbstractBuild)build, (TaskListener)listener, (String)this.getVersionTemplate());
            PipelineVersionContributor.setVersion(build, version);
            listener.getLogger().println("Creating version: " + version);
            if (this.isUpdateDisplayName()) {
                build.setDisplayName(version);
            }
        }
        catch (MacroEvaluationException e) {
            listener.getLogger().println("Error creating version: " + e.getMessage());
            LOG.log(Level.WARNING, "Error creating version", e);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public static String getVersion(AbstractBuild build) {
        List parameters = build.getActions(ParametersAction.class);
        for (ParametersAction parameter : parameters) {
            ParameterValue value = parameter.getParameter(VERSION_PARAMETER);
            if (!(value instanceof StringParameterValue)) continue;
            return ((StringParameterValue)value).value;
        }
        return null;
    }

    public static void setVersion(AbstractBuild build, String version) {
        ParametersAction action = new ParametersAction(new ParameterValue[]{new StringParameterValue(VERSION_PARAMETER, version)});
        build.addAction((Action)action);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Create Delivery Pipeline version";
        }
    }
}

