/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class PipelineProperty
extends JobProperty<AbstractProject<?, ?>> {
    private String taskName = null;
    private String stageName = null;

    public PipelineProperty() {
    }

    public PipelineProperty(String taskName, String stageName) {
        this.setStageName(stageName);
        this.setTaskName(taskName);
    }

    @Exported
    public String getTaskName() {
        return this.taskName;
    }

    @Exported
    public String getStageName() {
        return this.stageName;
    }

    public final void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public final void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public static Set<String> getStageNames() {
        List projects = Jenkins.getInstance().getAllItems(AbstractProject.class);
        HashSet<String> result = new HashSet<String>();
        for (AbstractProject project : projects) {
            PipelineProperty property = (PipelineProperty)project.getProperty(PipelineProperty.class);
            if (property == null || property.getStageName() == null) continue;
            result.add(property.getStageName());
        }
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "Pipeline description";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public AutoCompletionCandidates doAutoCompleteStageName(@QueryParameter String value) {
            if (value != null) {
                AutoCompletionCandidates c = new AutoCompletionCandidates();
                Set<String> stages = PipelineProperty.getStageNames();
                for (String stage : stages) {
                    if (!stage.toLowerCase().startsWith(value.toLowerCase())) continue;
                    c.add(stage);
                }
                return c;
            }
            return new AutoCompletionCandidates();
        }

        public FormValidation doCheckStageName(@QueryParameter String value) {
            return this.checkValue(value);
        }

        public FormValidation doCheckTaskName(@QueryParameter String value) {
            return this.checkValue(value);
        }

        protected FormValidation checkValue(String value) {
            if (value == null || "".equals(value)) {
                return FormValidation.ok();
            }
            if ("".equals(value.trim())) {
                return FormValidation.error((String)"Value needs to be empty or include characters and/or numbers");
            }
            return FormValidation.ok();
        }

        public PipelineProperty newInstance(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
            String task = sr.getParameter("taskName");
            String stage = sr.getParameter("stageName");
            if ("".equals(task)) {
                task = null;
            }
            if ("".equals(stage)) {
                stage = null;
            }
            if (task == null && stage == null) {
                return null;
            }
            return new PipelineProperty(task, stage);
        }
    }
}

