/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.tasks.UserAvatarResolver;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.util.RunList;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import se.diabol.jenkins.pipeline.PipelineProperty;
import se.diabol.jenkins.pipeline.model.Change;
import se.diabol.jenkins.pipeline.model.Pipeline;
import se.diabol.jenkins.pipeline.model.Stage;
import se.diabol.jenkins.pipeline.model.Status;
import se.diabol.jenkins.pipeline.model.Task;
import se.diabol.jenkins.pipeline.model.TestResult;
import se.diabol.jenkins.pipeline.model.Trigger;
import se.diabol.jenkins.pipeline.model.UserInfo;
import se.diabol.jenkins.pipeline.model.status.StatusFactory;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.pipeline.util.ProjectUtil;
import se.diabol.jenkins.pipeline.util.StageUtil;

public final class PipelineFactory {
    private static final int AVATAR_SIZE = 16;
    private static final Logger LOG = Logger.getLogger(PipelineFactory.class.getName());

    private PipelineFactory() {
    }

    public static Pipeline extractPipeline(String name, AbstractProject<?, ?> firstProject) {
        LinkedHashMap stages = Maps.newLinkedHashMap();
        for (AbstractProject<?, ?> project : ProjectUtil.getAllDownstreamProjects(firstProject).values()) {
            Task task = PipelineFactory.getPrototypeTask(project);
            PipelineProperty property = (PipelineProperty)project.getProperty(PipelineProperty.class);
            String stageName = property != null && !Strings.isNullOrEmpty((String)property.getStageName()) ? property.getStageName() : project.getDisplayName();
            Stage stage = (Stage)stages.get(stageName);
            if (stage == null) {
                stage = new Stage(stageName, Collections.<Task>emptyList(), null, null);
            }
            stages.put(stageName, new Stage(stage.getName(), Lists.newArrayList((Iterable)Iterables.concat(stage.getTasks(), Collections.singleton(task))), null, null));
        }
        Collection<Stage> stagesResult = stages.values();
        stagesResult = StageUtil.placeStages(firstProject, stagesResult);
        return new Pipeline(name, null, null, null, null, Lists.newArrayList(stagesResult), false);
    }

    private static Task getPrototypeTask(AbstractProject project) {
        PipelineProperty property = (PipelineProperty)project.getProperty(PipelineProperty.class);
        String taskName = property != null && !Strings.isNullOrEmpty((String)property.getTaskName()) ? property.getTaskName() : project.getDisplayName();
        Status status = project.isDisabled() ? StatusFactory.disabled() : StatusFactory.idle();
        List<AbstractProject> downstreams = ProjectUtil.getDownstreamProjects(project);
        ArrayList<String> downStreamTasks = new ArrayList<String>();
        for (AbstractProject downstreamProject : downstreams) {
            downStreamTasks.add(downstreamProject.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()));
        }
        return new Task(project.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), taskName, null, status, Util.fixNull((String)Jenkins.getInstance().getRootUrl()) + project.getUrl(), false, null, downStreamTasks);
    }

    public static Pipeline createPipelineLatest(Pipeline pipeline, ItemGroup context) {
        List<Pipeline> pipelines = PipelineFactory.createPipelineLatest(pipeline, 1, context);
        return !pipelines.isEmpty() ? pipelines.get(0) : null;
    }

    public static Pipeline createPipelineAggregated(Pipeline pipeline, ItemGroup context) {
        AbstractProject firstProject = PipelineFactory.getProject(pipeline.getStages().get(0).getTasks().get(0), context);
        ArrayList<Stage> stages = new ArrayList<Stage>();
        for (Stage stage : pipeline.getStages()) {
            ArrayList<Task> tasks = new ArrayList<Task>();
            AbstractBuild versionBuild = PipelineFactory.getHighestBuild(stage.getTasks(), firstProject, context);
            String version = null;
            if (versionBuild != null) {
                version = versionBuild.getDisplayName();
            }
            for (Task task : stage.getTasks()) {
                AbstractProject taskProject = PipelineFactory.getProject(task, context);
                AbstractBuild currentBuild = PipelineFactory.match((RunList<? extends AbstractBuild>)taskProject.getBuilds(), versionBuild);
                if (currentBuild != null) {
                    Status status = PipelineFactory.resolveStatus(taskProject, currentBuild);
                    String link = status.isIdle() ? task.getLink() : Util.fixNull((String)Jenkins.getInstance().getRootUrl()) + currentBuild.getUrl();
                    tasks.add(new Task(task.getId(), task.getName(), String.valueOf(currentBuild.getNumber()), status, link, task.isManual(), PipelineFactory.getTestResult(currentBuild), task.getDownstreamTasks()));
                    continue;
                }
                tasks.add(new Task(task.getId(), task.getName(), null, StatusFactory.idle(), task.getLink(), task.isManual(), null, task.getDownstreamTasks()));
            }
            stages.add(new Stage(stage.getName(), tasks, stage.getDownstreamStages(), stage.getTaskConnections(), version, stage.getRow(), stage.getColumn()));
        }
        return new Pipeline(pipeline.getName(), null, null, null, null, stages, true);
    }

    private static AbstractBuild getHighestBuild(List<Task> tasks, AbstractProject firstProject, ItemGroup context) {
        int highest = -1;
        for (Task task : tasks) {
            AbstractProject project = PipelineFactory.getProject(task, context);
            AbstractBuild firstBuild = PipelineFactory.getFirstUpstreamBuild(project, firstProject);
            if (firstBuild == null || firstBuild.getNumber() <= highest) continue;
            highest = firstBuild.getNumber();
        }
        if (highest > 0) {
            return firstProject.getBuildByNumber(highest);
        }
        return null;
    }

    public static List<Pipeline> createPipelineLatest(Pipeline pipeline, int noOfPipelines, ItemGroup context) {
        Task firstTask = pipeline.getStages().get(0).getTasks().get(0);
        AbstractProject firstProject = PipelineFactory.getProject(firstTask, context);
        ArrayList<Pipeline> result = new ArrayList<Pipeline>();
        Iterator it = firstProject.getBuilds().iterator();
        for (int i = 0; i < noOfPipelines && it.hasNext(); ++i) {
            AbstractBuild firstBuild = (AbstractBuild)it.next();
            List<Change> changes = PipelineFactory.getChanges(firstBuild);
            String timestamp = PipelineUtils.formatTimestamp(firstBuild.getTimeInMillis());
            ArrayList<Stage> stages = new ArrayList<Stage>();
            for (Stage stage : pipeline.getStages()) {
                ArrayList<Task> tasks = new ArrayList<Task>();
                for (Task task : stage.getTasks()) {
                    AbstractProject taskProject = PipelineFactory.getProject(task, context);
                    AbstractBuild currentBuild = PipelineFactory.match((RunList<? extends AbstractBuild>)taskProject.getBuilds(), firstBuild);
                    tasks.add(PipelineFactory.getTask(task, currentBuild, context));
                }
                stages.add(new Stage(stage.getName(), tasks, stage.getDownstreamStages(), stage.getTaskConnections(), null, stage.getRow(), stage.getColumn()));
            }
            Pipeline pipelineLatest = new Pipeline(pipeline.getName(), firstBuild.getDisplayName(), timestamp, PipelineFactory.getTriggeredBy(firstBuild), PipelineFactory.getContributors(firstBuild), stages, false);
            pipelineLatest.setChanges(changes);
            result.add(pipelineLatest);
        }
        return result;
    }

    protected static List<Change> getChanges(AbstractBuild<?, ?> build) {
        RepositoryBrowser repositoryBrowser = build.getProject().getScm().getBrowser();
        ArrayList<Change> result = new ArrayList<Change>();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            UserInfo user = PipelineFactory.getUser(entry.getAuthor());
            String changeLink = null;
            if (repositoryBrowser != null) {
                try {
                    URL link = repositoryBrowser.getChangeSetLink(entry);
                    if (link != null) {
                        changeLink = link.toExternalForm();
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Could not get changeset link", e);
                }
            }
            result.add(new Change(user, entry.getMsg(), entry.getCommitId(), changeLink));
        }
        return result;
    }

    private static Task getTask(Task task, AbstractBuild build, ItemGroup context) {
        AbstractProject project = PipelineFactory.getProject(task, context);
        Status status = PipelineFactory.resolveStatus(project, build);
        String link = build == null || status.isIdle() || status.isQueued() ? task.getLink() : Util.fixNull((String)Jenkins.getInstance().getRootUrl()) + build.getUrl();
        String buildId = build == null || status.isIdle() || status.isQueued() ? null : String.valueOf(build.getNumber());
        return new Task(task.getId(), task.getName(), buildId, status, link, task.isManual(), PipelineFactory.getTestResult(build), task.getDownstreamTasks());
    }

    protected static TestResult getTestResult(AbstractBuild build) {
        AggregatedTestResultAction tests;
        if (build != null && (tests = (AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class)) != null) {
            return new TestResult(tests.getFailCount(), tests.getSkipCount(), tests.getTotalCount(), build.getUrl() + tests.getUrlName());
        }
        return null;
    }

    protected static Set<UserInfo> getContributors(AbstractBuild<?, ?> build) {
        HashSet<UserInfo> contributors = new HashSet<UserInfo>();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            contributors.add(PipelineFactory.getUser(entry.getAuthor()));
        }
        return contributors;
    }

    protected static List<Trigger> getTriggeredBy(AbstractBuild<?, ?> build) {
        ArrayList<Trigger> result = new ArrayList<Trigger>();
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (cause instanceof Cause.UserIdCause) {
                result.add(new Trigger("MANUAL", "user " + PipelineFactory.getDisplayName(((Cause.UserIdCause)cause).getUserName())));
                continue;
            }
            if (cause instanceof Cause.RemoteCause) {
                result.add(new Trigger("REMOTE", "remote trigger"));
                continue;
            }
            if (cause instanceof Cause.UpstreamCause || cause instanceof Cause.UpstreamCause.DeeplyNestedUpstreamCause) {
                result.add(new Trigger("UPSTREAM", "upstream"));
                continue;
            }
            if (cause instanceof SCMTrigger.SCMTriggerCause) {
                result.add(new Trigger("SCM", "SCM change"));
                continue;
            }
            if (cause instanceof TimerTrigger.TimerTriggerCause) {
                result.add(new Trigger("TIMER", "timer"));
                continue;
            }
            result.add(new Trigger("UNKNOWN", "unknown cause"));
        }
        return result;
    }

    private static String getDisplayName(String userName) {
        return Jenkins.getInstance().getUser(userName).getDisplayName();
    }

    private static UserInfo getUser(User user) {
        return new UserInfo(user.getDisplayName(), user.getUrl(), PipelineFactory.getAvatarUrl(user));
    }

    private static String getAvatarUrl(User user) {
        ExtensionList resolvers = UserAvatarResolver.all();
        for (UserAvatarResolver resolver : resolvers) {
            String avatarUrl = resolver.findAvatarFor(user, 16, 16);
            if (avatarUrl == null) continue;
            return avatarUrl;
        }
        return null;
    }

    private static AbstractBuild match(RunList<? extends AbstractBuild> runList, AbstractBuild firstBuild) {
        if (firstBuild != null) {
            for (AbstractBuild currentBuild : runList) {
                if (!firstBuild.equals(PipelineFactory.getFirstUpstreamBuild(currentBuild, firstBuild.getProject()))) continue;
                return currentBuild;
            }
        }
        return null;
    }

    private static AbstractProject getProject(Task task, ItemGroup context) {
        return ProjectUtil.getProject(task.getId(), context);
    }

    protected static Status resolveStatus(AbstractProject project, AbstractBuild build) {
        if (build == null) {
            if (project.isInQueue()) {
                return StatusFactory.queued(project.getQueueItem().getInQueueSince());
            }
            if (project.isDisabled()) {
                return StatusFactory.disabled();
            }
            return StatusFactory.idle();
        }
        if (build.isBuilding()) {
            return StatusFactory.running((int)Math.round(100.0 * (double)(System.currentTimeMillis() - build.getTimestamp().getTimeInMillis()) / (double)build.getEstimatedDuration()), build.getTimeInMillis(), System.currentTimeMillis() - build.getTimestamp().getTimeInMillis());
        }
        Result result = build.getResult();
        if (Result.ABORTED.equals(result)) {
            return StatusFactory.cancelled(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.SUCCESS.equals(result)) {
            return StatusFactory.success(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.FAILURE.equals(result)) {
            return StatusFactory.failed(build.getTimeInMillis(), build.getDuration());
        }
        if (Result.UNSTABLE.equals(result)) {
            return StatusFactory.unstable(build.getTimeInMillis(), build.getDuration());
        }
        throw new IllegalStateException("Result " + result + " not recognized.");
    }

    protected static AbstractBuild getFirstUpstreamBuild(AbstractBuild build, AbstractProject first) {
        if (build == null) {
            return null;
        }
        if (build.getProject().equals(first)) {
            return build;
        }
        AbstractBuild upstreamBuild = PipelineFactory.getUpstreamBuild(build);
        if (upstreamBuild != null) {
            if (upstreamBuild.getProject().equals(first)) {
                return upstreamBuild;
            }
            return PipelineFactory.getFirstUpstreamBuild(upstreamBuild, first);
        }
        return build;
    }

    private static AbstractBuild getFirstUpstreamBuild(AbstractProject<?, ?> project, AbstractProject<?, ?> first) {
        RunList builds = project.getBuilds();
        for (AbstractBuild build : builds) {
            AbstractBuild upstream = PipelineFactory.getFirstUpstreamBuild(build, first);
            if (upstream == null || !upstream.getProject().equals(first)) continue;
            return upstream;
        }
        return null;
    }

    public static AbstractBuild getUpstreamBuild(AbstractBuild build) {
        List actions = build.getActions(CauseAction.class);
        for (CauseAction action : actions) {
            List causes = Util.filter((List)action.getCauses(), Cause.UpstreamCause.class);
            Iterator i$ = causes.iterator();
            if (!i$.hasNext()) continue;
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)i$.next();
            AbstractProject upstreamProject = ProjectUtil.getProject(upstreamCause.getUpstreamProject());
            if (upstreamProject == null) {
                return null;
            }
            return upstreamProject.getBuildByNumber(upstreamCause.getUpstreamBuild());
        }
        return null;
    }
}

