/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.withscript;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jenkinsci.plugins.pipeline.modeldefinition.withscript.WithScriptDescribable;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.workflow.cps.GroovySourceFileAllowlist;

public abstract class WithScriptDescriptor<T extends WithScriptDescribable<T>>
extends Descriptor<T> {
    protected WithScriptDescriptor() {
        ((WithScriptAllowlist)((Object)ExtensionList.lookupSingleton(WithScriptAllowlist.class))).registerScript(this.getScriptResource());
    }

    @NonNull
    public String getName() {
        Set symbolValues = SymbolLookup.getSymbolValue((Object)((Object)this));
        if (symbolValues.isEmpty()) {
            throw new IllegalArgumentException(this.clazz.getSimpleName() + " descriptor class " + ((Object)((Object)this)).getClass().getName() + " does not have a @Symbol and does not override getName().");
        }
        return (String)symbolValues.iterator().next();
    }

    @NonNull
    public String getScriptClass() {
        return this.clazz.getName() + "Script";
    }

    @SuppressFBWarnings(value={"UI_INHERITANCE_UNSAFE_GETRESOURCE"}, justification="We intentionally want to use the class loader for the subclass in this case")
    @NonNull
    private URL getScriptResource() {
        String scriptFile = "/" + this.getScriptClass().replace('.', '/') + ".groovy";
        return Objects.requireNonNull(((Object)((Object)this)).getClass().getResource(scriptFile), () -> "Unable to find resource file: " + scriptFile);
    }

    public T newInstance(Map<String, Object> arguments) throws Exception {
        return (T)((WithScriptDescribable)new DescribableModel(this.clazz).instantiate(arguments));
    }

    public T newInstance() throws Exception {
        return (T)((WithScriptDescribable)this.clazz.newInstance());
    }

    @Extension
    public static class WithScriptAllowlist
    extends GroovySourceFileAllowlist {
        private final Set<String> scriptUrls = new HashSet<String>();

        private void registerScript(URL scriptUrl) {
            this.scriptUrls.add(scriptUrl.toString());
        }

        public boolean isAllowed(String groovyResourceUrl) {
            return this.scriptUrls.contains(groovyResourceUrl);
        }
    }
}

