/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.scenario;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.report.BenchReport;
import org.jenkinsci.plugins.octoperf.scenario.Scenario;
import org.jenkinsci.plugins.octoperf.scenario.ScenarioApi;
import org.jenkinsci.plugins.octoperf.scenario.ScenarioService;

final class RetrofitScenarioService
implements ScenarioService {
    RetrofitScenarioService() {
    }

    @Override
    public BenchReport startTest(RestApiFactory apiFactory, String scenarioId, Optional<String> name) throws IOException {
        ScenarioApi api = apiFactory.create(ScenarioApi.class);
        return (BenchReport)api.run(scenarioId, name.map(Strings::emptyToNull).orElse(null)).execute().body();
    }

    @Override
    public Scenario find(RestApiFactory apiFactory, String id) throws IOException {
        ScenarioApi api = apiFactory.create(ScenarioApi.class);
        return (Scenario)api.find(id).execute().body();
    }

    @Override
    public List<Scenario> getScenariosByProject(RestApiFactory apiFactory, String projectId) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        ScenarioApi api = apiFactory.create(ScenarioApi.class);
        List scenarios = (List)api.list(projectId).execute().body();
        for (Scenario scenario : scenarios) {
            builder.add((Object)scenario);
        }
        return builder.build();
    }
}

