/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jenkinsci.plugins.octoperf.account.AccountApi;
import org.jenkinsci.plugins.octoperf.account.LoginResult;
import org.jenkinsci.plugins.octoperf.account.LoginSuccessful;
import org.jenkinsci.plugins.octoperf.account.SecurityToken;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import retrofit2.Call;

final class BearerClientAuthentication
implements RestClientAuthenticator {
    private static final String BEARER = "Bearer ";
    private volatile Optional<String> username = Optional.empty();
    private volatile Optional<String> password = Optional.empty();
    private volatile Optional<SecurityToken> token = Optional.empty();
    private final AccountApi accountApi;
    private final PrintStream logger;

    BearerClientAuthentication(AccountApi accountApi, PrintStream logger) {
        this.accountApi = (AccountApi)Preconditions.checkNotNull((Object)accountApi);
        this.logger = (PrintStream)Preconditions.checkNotNull((Object)logger);
    }

    public Request authenticate(Route route, Response response) {
        Optional<SecurityToken> token;
        try {
            if (this.username.isPresent()) {
                String login = this.username.get();
                Call<LoginResult> call = this.accountApi.login(login, this.password.get());
                token = Optional.ofNullable((LoginResult)call.execute().body()).filter(LoginSuccessful.class::isInstance).map(LoginSuccessful.class::cast).map(LoginSuccessful::getToken);
            } else {
                token = this.password.map(SecurityToken::new);
            }
        }
        catch (IOException e) {
            this.logger.println("Authentication failed. " + String.valueOf(e));
            e.printStackTrace(this.logger);
            return null;
        }
        if (token.isPresent()) {
            this.token = token;
            if (response.request().headers("Authorization").isEmpty()) {
                return response.request().newBuilder().header("Authorization", BEARER + token.get().getToken()).build();
            }
        }
        return null;
    }

    @Override
    public void onUsernameAndPassword(String username, String password) {
        this.username = Optional.ofNullable(Strings.emptyToNull((String)username.trim()));
        this.password = Optional.ofNullable(Strings.emptyToNull((String)password.trim()));
    }

    @Override
    public void onLogout() {
        this.username = Optional.empty();
        this.password = Optional.empty();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.token.isPresent()) {
            String tokenStr = this.token.get().getToken();
            request = request.newBuilder().header("Authorization", BEARER + tokenStr).build();
        }
        return chain.proceed(request);
    }
}

