/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.wrappers;

import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.Plugin;
import io.jenkins.update_center.wrappers.MavenRepositoryWrapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.annotation.CheckForNull;

public class VersionCappedMavenRepository
extends MavenRepositoryWrapper {
    @CheckForNull
    private final VersionNumber capPlugin;
    @CheckForNull
    private final VersionNumber capCore;

    public VersionCappedMavenRepository(@CheckForNull VersionNumber capPlugin, @CheckForNull VersionNumber capCore) {
        this.capPlugin = capPlugin;
        this.capCore = capCore;
    }

    @Override
    public TreeMap<VersionNumber, JenkinsWar> getJenkinsWarsByVersionNumber() throws IOException {
        TreeMap<VersionNumber, JenkinsWar> allWars = this.base.getJenkinsWarsByVersionNumber();
        if (this.capCore == null) {
            return allWars;
        }
        return new TreeMap<VersionNumber, JenkinsWar>((SortedMap<VersionNumber, JenkinsWar>)allWars.tailMap(this.capCore, true));
    }

    @Override
    public Collection<Plugin> listJenkinsPlugins() throws IOException {
        Collection<Plugin> r = this.base.listJenkinsPlugins();
        Iterator<Plugin> jtr = r.iterator();
        while (jtr.hasNext()) {
            Plugin h = jtr.next();
            TreeMap<VersionNumber, HPI> versionNumberHPIMap = new TreeMap<VersionNumber, HPI>(VersionNumber.DESCENDING);
            for (Map.Entry<VersionNumber, HPI> e : h.getArtifacts().entrySet()) {
                if (this.capPlugin == null) {
                    versionNumberHPIMap.put(e.getKey(), e.getValue());
                    if (versionNumberHPIMap.size() < 2) continue;
                    break;
                }
                try {
                    VersionNumber v = new VersionNumber(e.getValue().getRequiredJenkinsVersion());
                    if (v.compareTo(this.capPlugin) > 0) continue;
                    versionNumberHPIMap.put(e.getKey(), e.getValue());
                    if (versionNumberHPIMap.size() < 2) continue;
                    break;
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, "Failed to filter version " + String.valueOf(e.getKey()) + " by core dependency for plugin: " + h.getArtifactId(), x);
                }
            }
            h.getArtifacts().entrySet().retainAll(versionNumberHPIMap.entrySet());
            if (!h.getArtifacts().isEmpty()) continue;
            jtr.remove();
        }
        return r;
    }
}

