/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.wrappers;

import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.Plugin;
import io.jenkins.update_center.PluginFilter;
import io.jenkins.update_center.wrappers.MavenRepositoryWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class FilteringRepository
extends MavenRepositoryWrapper {
    private List<PluginFilter> pluginFilters = new ArrayList<PluginFilter>();

    private void addPluginFilter(@Nonnull PluginFilter filter) {
        this.pluginFilters.add(filter);
    }

    @Override
    public Collection<Plugin> listJenkinsPlugins() throws IOException {
        Collection<Plugin> r = this.base.listJenkinsPlugins();
        Iterator<Plugin> jtr = r.iterator();
        while (jtr.hasNext()) {
            Plugin h = jtr.next();
            Iterator<Map.Entry<VersionNumber, HPI>> itr = h.getArtifacts().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<VersionNumber, HPI> e = itr.next();
                for (PluginFilter filter : this.pluginFilters) {
                    if (!filter.shouldIgnore(e.getValue())) continue;
                    itr.remove();
                }
            }
            if (!h.getArtifacts().isEmpty()) continue;
            jtr.remove();
        }
        return r;
    }

    public FilteringRepository withPluginFilter(PluginFilter pluginFilter) {
        this.addPluginFilter(pluginFilter);
        return this;
    }
}

