/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.wrappers;

import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.Plugin;
import io.jenkins.update_center.wrappers.MavenRepositoryWrapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class AlphaBetaOnlyRepository
extends MavenRepositoryWrapper {
    private boolean negative;

    public AlphaBetaOnlyRepository(boolean negative) {
        this.negative = negative;
    }

    @Override
    public Collection<Plugin> listJenkinsPlugins() throws IOException {
        Collection<Plugin> r = this.base.listJenkinsPlugins();
        Iterator<Plugin> jtr = r.iterator();
        while (jtr.hasNext()) {
            Plugin h = jtr.next();
            Iterator<Map.Entry<VersionNumber, HPI>> itr = h.getArtifacts().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<VersionNumber, HPI> e = itr.next();
                if (e.getValue().isAlphaOrBeta() ^ this.negative) continue;
                itr.remove();
            }
            if (!h.getArtifacts().isEmpty()) continue;
            jtr.remove();
        }
        return r;
    }
}

